/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support.reduce;

import com.atlassian.confluence.spaces.Space;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LightSpace
implements Serializable {
    private static final long serialVersionUID = 3881513363283380743L;
    private String key;
    private String name;
    private String creatorName;

    public static LightSpace fromSpace(Space space) {
        return new LightSpace(space);
    }

    public static List<LightSpace> fromSpaces(Collection<Space> spaces) {
        ArrayList<LightSpace> lightSpaces = new ArrayList<LightSpace>(spaces.size());
        for (Space space : spaces) {
            lightSpaces.add(LightSpace.fromSpace(space));
        }
        return lightSpaces;
    }

    public LightSpace() {
    }

    private LightSpace(Space space) {
        this.key = space.getKey();
        this.name = space.getName();
        this.creatorName = space.getCreator() != null ? space.getCreator().getName() : null;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public int hashCode() {
        return Objects.hashCode(this.key, this.name);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LightSpace other = (LightSpace)obj;
        return Objects.equal(this.key, other.key) && Objects.equal(this.name, other.name);
    }

    public String toString() {
        return String.format("LightSpace %s \"%s\"", this.key, this.name);
    }
}

