/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.google.common.collect.HashMultimap;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleLabelHelper;
import com.midori.confluence.plugin.archiving.service.support.DateTimeProvider;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentTraversalHelper {
    private static Logger log = LoggerFactory.getLogger(ContentTraversalHelper.class);
    public static final String ARCHIVING_REASON_TAG = "#archive";
    private LabelManager labelManager;
    private PageManager pageManager;

    public ContentTraversalHelper(LabelManager labelManager, PageManager pageManager) {
        this.labelManager = labelManager;
        this.pageManager = pageManager;
    }

    public Set<Page> findPagesLabeledWith(Space space, String labelName, boolean includeDescendants) {
        HashSet<Page> pagesLabeled = new HashSet<Page>();
        Label label = this.labelManager.getLabel(labelName);
        if (label != null) {
            List roots = this.labelManager.getCurrentContentForLabelAndSpace(label, space.getKey());
            for (Labelable root : roots) {
                Page rootPage = ModelUtils.asPage(root);
                if (rootPage == null) continue;
                pagesLabeled.add(rootPage);
                if (!includeDescendants) continue;
                pagesLabeled.addAll(rootPage.getDescendants());
            }
        }
        return pagesLabeled;
    }

    public Map<Page, String> findPagesLabeledWithAndLabelers(Space space, String labelName, boolean includeDescendants) {
        Set<Page> pages = this.findPagesLabeledWith(space, labelName, includeDescendants);
        HashMap<Page, String> pagesToLabelers = new HashMap<Page, String>();
        block0: for (Page page : pages) {
            for (Labelling labelling : page.getLabellings()) {
                if (!labelling.getLabel().getName().equals(labelName)) continue;
                String owningUserName = labelling.getOwningUser() != null ? labelling.getOwningUser().getName() : null;
                pagesToLabelers.put(page, owningUserName);
                if (!includeDescendants) continue block0;
                for (Page descendant : page.getDescendants()) {
                    pagesToLabelers.put(descendant, owningUserName);
                }
                continue block0;
            }
        }
        return pagesToLabelers;
    }

    public SortedMap<Date, Map<Page, String>> findPagesLabelledWithYyymmdd(Space space, String yymmddSingleLabelPrefix, String yymmddTreeLabelPrefix, String labelDescription) {
        TreeMap<Date, Map<Page, String>> result = new TreeMap<Date, Map<Page, String>>();
        Map<Label, Date> labels = this.findYymmddSuffixedLabelsBySpace(space.getKey(), yymmddSingleLabelPrefix, yymmddTreeLabelPrefix);
        log.debug(String.format("%d %s found in <%s>", labels.size(), labelDescription, space.getKey()));
        for (Label label : labels.keySet()) {
            Date date = labels.get(label);
            if (date.getTime() < DateTimeProvider.currentTimeMillis()) {
                boolean recursive = ContentLifecycleLabelHelper.isRecursiveLabel(label.getName());
                Map<Page, String> yymmddLabeledPages = this.findPagesLabeledWithAndLabelers(space, label.getName(), recursive);
                log.debug(String.format("Date already passed in label <%s>: %d pages found in <%s>", label.getName(), yymmddLabeledPages.size(), space.getKey()));
                for (Map.Entry<Page, String> entry : yymmddLabeledPages.entrySet()) {
                    result.computeIfAbsent(date, k -> new HashMap()).put(entry.getKey(), entry.getValue());
                }
                continue;
            }
            log.debug(String.format("Date not passed yet in label <%s>", label.getName()));
        }
        return result;
    }

    public List<Page> findBranch(Page page) {
        ArrayList<Page> branch = new ArrayList<Page>();
        if (page != null) {
            branch.addAll(page.getAncestors());
            branch.add(page);
        }
        return branch;
    }

    public HashMultimap<Long, String> findPagesLabelledWithUserName(Space space, String userNameSingleLabelNamePrefix, String userNameTreeLabelNamePrefix, String labelDescription) {
        HashMultimap<Long, String> result = HashMultimap.create();
        Map<Label, String> labels = this.findUserNameSuffixedLabelsBySpace(space.getKey(), userNameSingleLabelNamePrefix, userNameTreeLabelNamePrefix);
        log.debug(String.format("%d %s found in <%s>", labels.size(), labelDescription, space.getKey()));
        for (Label label : labels.keySet()) {
            String userName = labels.get(label);
            boolean recursive = ContentLifecycleLabelHelper.isRecursiveLabel(label.getName());
            Set<Page> pages = this.findPagesLabeledWith(space, label.getName(), recursive);
            log.debug(String.format("User name found in label <%s>: %d pages found in <%s>", label.getName(), pages.size(), space.getKey()));
            for (Page page : pages) {
                result.put((Object)page.getId(), (Object)userName);
            }
        }
        return result;
    }

    public List<Page> findPartialBranch(Page page, Map<Page, Page> pagesToStopPages) {
        ArrayList<Page> branch = new ArrayList<Page>();
        while (page != null) {
            branch.add(0, page);
            if (pagesToStopPages.get(page) != null) break;
            page = page.getParent();
        }
        return branch;
    }

    public String getArchivingReason(Page page) {
        return this.getArchivingReason(page, true);
    }

    public String getArchivingReason(Page page, boolean searchAncestors) {
        String reason = null;
        for (Comment comment : page.getComments()) {
            String commentText = comment.getBodyAsStringWithoutMarkup();
            if (!StringUtils.containsIgnoreCase((CharSequence)commentText, (CharSequence)ARCHIVING_REASON_TAG)) continue;
            reason = StringUtils.trimToNull((String)StringUtils.remove((String)commentText, (String)ARCHIVING_REASON_TAG));
        }
        if (searchAncestors && reason == null && page.getParent() != null) {
            reason = this.getArchivingReason(page.getParent(), searchAncestors);
        }
        return reason;
    }

    public <T> Map<Page, T> sortPageKeyedMapByPosition(Space space, Map<Page, T> pageKeyedMap) {
        SortPagesByPositionVisitor visitor = new SortPagesByPositionVisitor(pageKeyedMap.keySet());
        visitor.visit(space);
        Set<Page> pagesSorted = visitor.getSortedPages();
        if (pagesSorted.size() != pageKeyedMap.size()) {
            log.warn("Size of sorted pages " + pagesSorted.size() + " should equal to " + pageKeyedMap.size() + " unsorted pages");
        }
        LinkedHashMap<Page, T> sortedPageKeyedMap = new LinkedHashMap<Page, T>();
        for (Page page : pagesSorted) {
            sortedPageKeyedMap.put(page, pageKeyedMap.get(page));
        }
        return sortedPageKeyedMap;
    }

    protected Map<Label, String> findUserNameSuffixedLabelsBySpace(String spaceKey, String userNameSingleLabelNamePrefix, String userNameTreeLabelNamePrefix) {
        return this.applyToLabels(spaceKey, labelName -> ContentLifecycleLabelHelper.parseUserNameFromLabel(labelName, userNameSingleLabelNamePrefix, userNameTreeLabelNamePrefix));
    }

    protected Map<Label, Date> findYymmddSuffixedLabelsBySpace(String spaceKey, String yymmddSingleLabelNamePrefix, String yymmddTreeLabelNamePrefix) {
        return this.applyToLabels(spaceKey, labelName -> ContentLifecycleLabelHelper.parseDateFromLabel(labelName, yymmddSingleLabelNamePrefix, yymmddTreeLabelNamePrefix));
    }

    private <T> Map<Label, T> applyToLabels(String spaceKey, Function<String, T> func) {
        HashMap<Label, T> results = new HashMap<Label, T>();
        List labels = this.labelManager.getLabelsInSpace(spaceKey);
        for (Label label : labels) {
            T labelResult;
            String labelName = StringUtils.trimToNull((String)label.getName());
            if (labelName == null || (labelResult = func.apply(labelName)) == null) continue;
            results.put(label, labelResult);
        }
        return results;
    }

    private class SortPagesByPositionVisitor {
        private Set<Page> pages;
        private Set<Page> sortedPages = new LinkedHashSet<Page>();

        public SortPagesByPositionVisitor(Set<Page> pages) {
            this.pages = pages;
        }

        public Set<Page> getSortedPages() {
            return this.sortedPages;
        }

        public void visit(Space space) {
            log.debug(String.format("Started sorting %s pages of space <%s> while doing a full page tree traversal", this.pages.size(), space.getKey()));
            List topLevelPages = ContentTraversalHelper.this.pageManager.getTopLevelPages(space);
            for (Page topLevelPage : topLevelPages) {
                this.visit(topLevelPage);
            }
            log.debug(String.format("Finished traversing page tree of space <%s>", space.getKey()));
        }

        private void visit(Page page) {
            if (this.allPagesAreSorted()) {
                return;
            }
            if (this.pages.contains(page)) {
                this.sortedPages.add(page);
            }
            List children = page.getSortedChildren();
            for (Page child : children) {
                this.visit(child);
            }
        }

        private boolean allPagesAreSorted() {
            return this.pages.size() == this.sortedPages.size();
        }
    }
}

