/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support;

import com.atlassian.confluence.core.DataSourceFactory;
import com.atlassian.confluence.mail.template.PreRenderedMailNotificationQueueItem;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.model.NotificationEmailTemplate;
import com.midori.confluence.plugin.archiving.model.type.LifecycleNotificationReason;
import com.midori.confluence.plugin.archiving.model.type.NotificationEmailTemplateType;
import com.midori.confluence.plugin.archiving.model.util.ReplyTo;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingConfigurationManager;
import com.midori.confluence.plugin.archiving.service.persistence.NotificationEmailTemplateManager;
import com.midori.confluence.plugin.archiving.service.persistence.SystemSettingsManager;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleActorHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleStatusHelper;
import com.midori.confluence.plugin.archiving.service.support.reduce.DataReducer;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightPage;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightSpace;
import com.midori.confluence.plugin.archiving.tool.PageStatsTool;
import com.midori.confluence.plugin.archiving.util.BooleanConfigurationSettingExtractor;
import com.midori.confluence.plugin.archiving.util.StringListConfigurationSettingExtractor;
import com.midori.confluence.plugin.archiving.util.limited.LimitedList;
import com.midori.confluence.plugin.archiving.util.limited.LimitedMap;
import com.midori.confluence.plugin.archiving.web.support.RelativeTimeHelper;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.activation.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentLifecycleNotificationHelper {
    private static Logger log = LoggerFactory.getLogger(ContentLifecycleNotificationHelper.class);
    private static final String PAGE_ICON_PATH = "/images/icons/contenttypes/page_16.png";
    private DataSourceFactory dataSourceFactory;
    private MultiQueueTaskManager multiQueueTaskManager;
    private SettingsManager settingsManager;
    private UserAccessor userAccessor;
    private UserManager userManager;
    private ContentArchivingConfigurationManager contentArchivingConfigurationManager;
    private ContentLifecycleActorHelper contentLifecycleActorHelper;
    private ContentLifecycleStatusHelper contentLifecycleStatusHelper;
    private NotificationEmailTemplateManager notificationEmailTemplateManager;

    public ContentLifecycleNotificationHelper(DataSourceFactory dataSourceFactory, MultiQueueTaskManager multiQueueTaskManager, SettingsManager settingsManager, UserAccessor userAccessor, UserManager userManager, ContentArchivingConfigurationManager contentArchivingConfigurationManager, ContentLifecycleActorHelper contentLifecycleActorHelper, ContentLifecycleStatusHelper contentLifecycleStatusHelper, NotificationEmailTemplateManager notificationEmailTemplateManager) {
        this.dataSourceFactory = dataSourceFactory;
        this.multiQueueTaskManager = multiQueueTaskManager;
        this.settingsManager = settingsManager;
        this.userAccessor = userAccessor;
        this.userManager = userManager;
        this.contentArchivingConfigurationManager = contentArchivingConfigurationManager;
        this.contentLifecycleActorHelper = contentLifecycleActorHelper;
        this.contentLifecycleStatusHelper = contentLifecycleStatusHelper;
        this.notificationEmailTemplateManager = notificationEmailTemplateManager;
    }

    public <V> Map<LifecycleNotificationReason, Map<String, LimitedMap<LightSpace, LimitedList<LightPage>>>> findAddressees(LimitedMap<LightSpace, LimitedMap<LightPage, V>> spacesToPages, Function<LightPage, LightPage> pageMapper, BooleanConfigurationSettingExtractor notifyAuthorExtractor, BooleanConfigurationSettingExtractor notifyLastModifierExtractor, BooleanConfigurationSettingExtractor notifyOwnersExtractor, BooleanConfigurationSettingExtractor notifySpaceAdminsExtractor, BooleanConfigurationSettingExtractor notifySpaceCreatorExtractor, BooleanConfigurationSettingExtractor notifySupervisorsExtractor, StringListConfigurationSettingExtractor supervisorsExtractor) {
        HashMap<LifecycleNotificationReason, Map<String, Multimap<LightSpace, LightPage>>> reasonsToAddresseesToSpacesToPages = new HashMap<LifecycleNotificationReason, Map<String, Multimap<LightSpace, LightPage>>>();
        for (LightSpace space : spacesToPages.keySet()) {
            Set<LightPage> pagesInSpace = spacesToPages.get(space).keySet();
            if (pagesInSpace.isEmpty()) continue;
            ContentArchivingConfiguration config = this.contentArchivingConfigurationManager.findResolvedConfiguration(space.getKey());
            if (notifyAuthorExtractor.extract(config)) {
                Multimap<String, LightPage> authors = this.contentLifecycleActorHelper.findAuthorsByPages(pagesInSpace, pageMapper);
                ContentLifecycleNotificationHelper.mergeAddressees(reasonsToAddresseesToSpacesToPages, LifecycleNotificationReason.AUTHOR, space, authors);
            }
            if (notifyLastModifierExtractor.extract(config)) {
                Multimap<String, LightPage> lastModifiers = this.contentLifecycleActorHelper.findLastModifiersByPages(pagesInSpace, pageMapper);
                ContentLifecycleNotificationHelper.mergeAddressees(reasonsToAddresseesToSpacesToPages, LifecycleNotificationReason.LAST_MODIFIER, space, lastModifiers);
            }
            if (notifyOwnersExtractor.extract(config)) {
                Multimap<String, LightPage> owners = this.contentLifecycleActorHelper.findOwnersByPages(pagesInSpace);
                ContentLifecycleNotificationHelper.mergeAddressees(reasonsToAddresseesToSpacesToPages, LifecycleNotificationReason.OWNER, space, owners);
            }
            if (notifySpaceAdminsExtractor.extract(config)) {
                Multimap<String, LightPage> spaceAdmins = this.contentLifecycleActorHelper.findSpaceAdminsByPages(pagesInSpace, space);
                ContentLifecycleNotificationHelper.mergeAddressees(reasonsToAddresseesToSpacesToPages, LifecycleNotificationReason.SPACE_ADMIN, space, spaceAdmins);
            }
            if (notifySpaceCreatorExtractor.extract(config)) {
                Multimap<String, LightPage> spaceCreators = this.contentLifecycleActorHelper.findSpaceCreatorsByPages(pagesInSpace, space);
                ContentLifecycleNotificationHelper.mergeAddressees(reasonsToAddresseesToSpacesToPages, LifecycleNotificationReason.SPACE_CREATOR, space, spaceCreators);
            }
            if (!notifySupervisorsExtractor.extract(config)) continue;
            for (String supervisor : supervisorsExtractor.extract(config)) {
                if (!StringUtils.isNotBlank((CharSequence)supervisor)) continue;
                ArrayListMultimap<String, LightPage> supervisors = ArrayListMultimap.create();
                supervisors.putAll(supervisor, pagesInSpace);
                ContentLifecycleNotificationHelper.mergeAddressees(reasonsToAddresseesToSpacesToPages, LifecycleNotificationReason.SUPERVISOR, space, supervisors);
            }
        }
        return ContentLifecycleNotificationHelper.limitAddressees(reasonsToAddresseesToSpacesToPages);
    }

    public static <V> Map<LifecycleNotificationReason, Map<String, LimitedMap<LightSpace, LimitedList<LightPage>>>> extractAddressees(LimitedMap<LightSpace, LimitedMap<LightPage, V>> spacesToPageKeyedMaps, LifecycleNotificationReason reason, Function<V, String> addresseeExtractor) {
        HashMap<LifecycleNotificationReason, Map<String, Multimap<LightSpace, LightPage>>> reasonsToAddresseesToSpacesToPages = new HashMap<LifecycleNotificationReason, Map<String, Multimap<LightSpace, LightPage>>>();
        for (LightSpace space : spacesToPageKeyedMaps.keySet()) {
            Map pageKeyedMap = spacesToPageKeyedMaps.get(space);
            for (LightPage page : pageKeyedMap.keySet()) {
                Object value = pageKeyedMap.get(page);
                String addressee = addresseeExtractor.apply(value);
                if (!StringUtils.isNotBlank((CharSequence)addressee)) continue;
                ArrayListMultimap<String, LightPage> labelers = ArrayListMultimap.create();
                labelers.put(addressee, page);
                ContentLifecycleNotificationHelper.mergeAddressees(reasonsToAddresseesToSpacesToPages, reason, space, labelers);
            }
        }
        return ContentLifecycleNotificationHelper.limitAddressees(reasonsToAddresseesToSpacesToPages);
    }

    private static void mergeAddressees(Map<LifecycleNotificationReason, Map<String, Multimap<LightSpace, LightPage>>> reasonsToAddresseesToSpacesToPages, LifecycleNotificationReason reason, LightSpace space, Multimap<String, LightPage> addresseesToPages) {
        Map addresseesToSpacesToPages = reasonsToAddresseesToSpacesToPages.computeIfAbsent(reason, k -> new HashMap());
        for (String addressee : addresseesToPages.keySet()) {
            ArrayListMultimap<LightSpace, LightPage> spacesToPages = (ArrayListMultimap<LightSpace, LightPage>)addresseesToSpacesToPages.get(addressee);
            if (spacesToPages == null) {
                spacesToPages = ArrayListMultimap.create();
                addresseesToSpacesToPages.put(addressee, spacesToPages);
            }
            Collection<LightPage> pages = addresseesToPages.get(addressee);
            spacesToPages.putAll(space, pages);
        }
    }

    private static Map<LifecycleNotificationReason, Map<String, LimitedMap<LightSpace, LimitedList<LightPage>>>> limitAddressees(Map<LifecycleNotificationReason, Map<String, Multimap<LightSpace, LightPage>>> reasonsToAddresseesToSpacesToPages) {
        TreeMap<LifecycleNotificationReason, Map<String, LimitedMap<LightSpace, LimitedList<LightPage>>>> reasonsToAddresseesToLimitedSpacesToLimitedPages = new TreeMap<LifecycleNotificationReason, Map<String, LimitedMap<LightSpace, LimitedList<LightPage>>>>();
        for (LifecycleNotificationReason reason : reasonsToAddresseesToSpacesToPages.keySet()) {
            TreeMap<String, LimitedMap<LightSpace, LimitedList<LightPage>>> addresseesToLimitedSpacesToLimitedPages = new TreeMap<String, LimitedMap<LightSpace, LimitedList<LightPage>>>();
            reasonsToAddresseesToLimitedSpacesToLimitedPages.put(reason, addresseesToLimitedSpacesToLimitedPages);
            for (String addressee : reasonsToAddresseesToSpacesToPages.get((Object)reason).keySet()) {
                Multimap<LightSpace, LightPage> spacesToPages = reasonsToAddresseesToSpacesToPages.get((Object)reason).get(addressee);
                LimitedMap<LightSpace, LimitedList<LightPage>> limitedSpacesToLimitedPages = DataReducer.limitSpaceKeyedPageMultimap(spacesToPages, SystemSettingsManager.getEmailsMaxSpaces(), SystemSettingsManager.getEmailsMaxPagesPerSpace());
                addresseesToLimitedSpacesToLimitedPages.put(addressee, limitedSpacesToLimitedPages);
            }
        }
        return reasonsToAddresseesToLimitedSpacesToLimitedPages;
    }

    public int sendEmails(Map<LifecycleNotificationReason, Map<String, LimitedMap<LightSpace, LimitedList<LightPage>>>> reasonsToAddresseesToSpacesToPages, NotificationEmailTemplateType notificationEmailType, Map<String, ?> additionalContext, ReplyTo replyTo) {
        int emailsSent = 0;
        for (LifecycleNotificationReason reason : reasonsToAddresseesToSpacesToPages.keySet()) {
            NotificationEmailTemplate notificationEmailTemplate = this.notificationEmailTemplateManager.getNotificationEmailTemplate(notificationEmailType);
            emailsSent += this.sendEmailsInternal(reasonsToAddresseesToSpacesToPages.get((Object)reason), notificationEmailTemplate, ImmutableMap.builder().put("reason", reason).putAll(additionalContext).build(), replyTo);
        }
        return emailsSent;
    }

    private int sendEmailsInternal(Map<String, LimitedMap<LightSpace, LimitedList<LightPage>>> addresseesToSpacesToPages, NotificationEmailTemplate notificationEmailTemplate, Map<String, ?> additionalContext, ReplyTo replyTo) {
        int mailsSent = 0;
        for (String userName : addresseesToSpacesToPages.keySet()) {
            try {
                boolean isEmailWithPageList;
                User user = this.findUserByName(userName);
                if (user == null) continue;
                LimitedMap<LightSpace, LimitedList<LightPage>> spacesToPages = addresseesToSpacesToPages.get(userName);
                int pageCount = 0;
                for (LimitedList<LightPage> pagesInSpace : spacesToPages.values()) {
                    pageCount += pagesInSpace.getNonLimitedSize();
                }
                String subject = (String)StringUtils.defaultIfEmpty((CharSequence)notificationEmailTemplate.getSubject(), (CharSequence)notificationEmailTemplate.getType().getDefaultSubject());
                subject = subject.replace("${pages.size()}", Integer.toString(pageCount));
                if (additionalContext.containsKey("page") && additionalContext.get("page") instanceof LightPage) {
                    subject = subject.replace("${page.title}", ((LightPage)additionalContext.get("page")).getTitle());
                }
                if (this.contentLifecycleStatusHelper.isDraft()) {
                    subject = subject + " [TRIAL VERSION]";
                } else if (!this.contentLifecycleStatusHelper.isDisposable()) {
                    subject = subject + " [UNLICENSED]";
                }
                PreRenderedMailNotificationQueueItem.Builder queueItemBuilder = PreRenderedMailNotificationQueueItem.with((User)user, (String)"", (String)subject);
                queueItemBuilder.andSender(this.getSender());
                List replyToUsers = null;
                if (replyTo.shouldReplyToSender()) {
                    HashSet<String> replyToUsernames = Sets.newHashSet(replyTo.getSender());
                    if (replyTo.shouldReplyToAllRecipients()) {
                        replyToUsernames.addAll(addresseesToSpacesToPages.keySet());
                    }
                    replyToUsers = replyToUsernames.stream().map(String.class::cast).map(this::findUserByName).filter(Objects::nonNull).sorted(Comparator.comparing(User::getFullName)).collect(Collectors.toList());
                    String replyToEmails = replyToUsers.stream().map(User::getEmail).filter(email -> !email.equals(user.getEmail())).sorted().collect(Collectors.joining(","));
                    queueItemBuilder.andReplyTo(replyToEmails);
                }
                boolean bl = isEmailWithPageList = !NotificationEmailTemplateType.DISCUSSED_PAGES.equals((Object)notificationEmailTemplate.getType());
                if (isEmailWithPageList) {
                    DataSource pageIcon = this.dataSourceFactory.getServletContainerResource(PAGE_ICON_PATH, "page-icon@midori-global.com");
                    queueItemBuilder.andRelatedBodyPart(pageIcon);
                }
                Map defaultVelocityContext = MacroUtils.defaultVelocityContext();
                PreRenderedMailNotificationQueueItem queueItem = queueItemBuilder.build();
                queueItem.addVelocityContextParam("user", (Object)user);
                if (replyToUsers != null) {
                    queueItem.addVelocityContextParam("replyToUsers", replyToUsers);
                }
                queueItem.addVelocityContextParam("subject", (Object)subject);
                queueItem.addVelocityContextParam("spacesToPages", spacesToPages);
                queueItem.addVelocityContextParam("pageStatsTool", (Object)new PageStatsTool(this.contentArchivingConfigurationManager));
                queueItem.addVelocityContextParam("relativeTimeHelper", (Object)new RelativeTimeHelper());
                queueItem.addVelocityContextParam("req", defaultVelocityContext.getOrDefault("request", defaultVelocityContext.get("req")));
                queueItem.addVelocityContextParam("webwork", defaultVelocityContext.getOrDefault("htmlUtil", defaultVelocityContext.get("webwork")));
                for (String key : additionalContext.keySet()) {
                    queueItem.addVelocityContextParam(key, additionalContext.get(key));
                }
                queueItem.setTemplateContent(notificationEmailTemplate.getContent());
                queueItem.render();
                this.multiQueueTaskManager.addTask("mail", (Task)queueItem);
                ++mailsSent;
                log.debug(String.format("Mail queued for <%s>: \"%s\" (%d bytes)", userName, subject, queueItem.getBody().length()));
            }
            catch (Exception ex) {
                log.error("Failed to send mail to <" + userName + ">", (Throwable)ex);
            }
        }
        return mailsSent;
    }

    private User getSender() {
        String instanceName = this.settingsManager.getGlobalSettings().getSiteTitle();
        String fromSuffix = "Better Content Archiving";
        String from = "Confluence".equals(instanceName) ? fromSuffix : String.format("%s %s", instanceName, fromSuffix);
        if (!StringUtils.isBlank((CharSequence)from)) {
            return new ConfluenceUserImpl(null, from, "");
        }
        return null;
    }

    private User findUserByName(String userName) {
        try {
            User user = this.userManager.getUser(userName);
            if (user == null) {
                log.warn("Skipping missing addressee <" + userName + ">");
                return null;
            }
            if (this.userAccessor.isDeactivated(userName)) {
                log.debug("Skipping disabled addressee <" + userName + ">");
                return null;
            }
            return user;
        }
        catch (EntityException e) {
            log.warn("Failed to find addressee <" + userName + ">, skipping");
            return null;
        }
    }
}

