/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.persistence;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.tx.Transactional;
import com.atlassian.core.util.ClassLoaderUtils;
import com.midori.confluence.plugin.archiving.model.NotificationEmailTemplate;
import com.midori.confluence.plugin.archiving.model.ao.NotificationEmailTemplateAo;
import com.midori.confluence.plugin.archiving.model.type.NotificationEmailTemplateType;
import java.io.InputStream;
import java.util.Date;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationEmailTemplateManager {
    private static Logger log = LoggerFactory.getLogger(NotificationEmailTemplateManager.class);
    private ActiveObjects ao;

    public NotificationEmailTemplateManager(ActiveObjects ao) {
        this.ao = ao;
    }

    @Transactional
    public NotificationEmailTemplate getNotificationEmailTemplate(NotificationEmailTemplateType notificationEmailType) {
        NotificationEmailTemplateAo notificationEmailAo = this.findNotificationEmailTemplateByType(notificationEmailType);
        if (notificationEmailAo == null) {
            return NotificationEmailTemplate.createDefault(notificationEmailType, this.getDefaultTemplateContent(notificationEmailType));
        }
        return NotificationEmailTemplate.fromAo(notificationEmailType, notificationEmailAo);
    }

    private NotificationEmailTemplateAo findNotificationEmailTemplateByType(NotificationEmailTemplateType notificationEmailType) {
        NotificationEmailTemplateAo[] notificationEmailAos = (NotificationEmailTemplateAo[])this.ao.find(NotificationEmailTemplateAo.class, "TYPE = ?", new Object[]{notificationEmailType.getShortName()});
        return notificationEmailAos.length > 0 ? notificationEmailAos[0] : null;
    }

    @Transactional
    public void updateNotificationEmailTemplate(NotificationEmailTemplateType notificationEmailType, String subject, String content) {
        NotificationEmailTemplateAo notificationEmailAo = this.findNotificationEmailTemplateByType(notificationEmailType);
        if (notificationEmailAo == null) {
            notificationEmailAo = this.createNotificationEmailTemplate(notificationEmailType, subject, content);
        } else {
            notificationEmailAo.setSubject(subject);
            notificationEmailAo.setContent(content);
        }
        notificationEmailAo.setUpdated(new Date());
        notificationEmailAo.save();
    }

    @Transactional
    public void resetNotificationEmailTemplate(NotificationEmailTemplateType notificationEmailType) {
        NotificationEmailTemplateAo notificationEmailAo = this.findNotificationEmailTemplateByType(notificationEmailType);
        if (notificationEmailAo != null) {
            this.ao.delete(new RawEntity[]{notificationEmailAo});
        }
    }

    private NotificationEmailTemplateAo createNotificationEmailTemplate(NotificationEmailTemplateType notificationEmailType, String subject, String content) {
        return (NotificationEmailTemplateAo)this.ao.create(NotificationEmailTemplateAo.class, new DBParam[]{new DBParam("TYPE", (Object)notificationEmailType.getShortName()), new DBParam("SUBJECT", (Object)subject), new DBParam("CONTENT", (Object)content), new DBParam("UPDATED", (Object)new Date())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDefaultTemplateContent(NotificationEmailTemplateType notificationEmailType) {
        String content = null;
        String resourceName = "templates/email/html/" + notificationEmailType.getDefaultTemplateFileName();
        InputStream in = ClassLoaderUtils.getResourceAsStream((String)resourceName, this.getClass());
        try {
            content = IOUtils.toString((InputStream)in);
        }
        catch (Exception ex) {
            log.error(String.format("Failed to load default notification email template <%s>", resourceName));
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return content;
    }
}

