/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service;

import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.pages.Page;
import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.model.ContentUpdate;
import com.midori.confluence.plugin.archiving.model.ContentView;
import com.midori.confluence.plugin.archiving.model.base.ContentEvent;
import com.midori.confluence.plugin.archiving.model.util.Labeling;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.model.util.YymmddLabelingWithAncestor;
import com.midori.confluence.plugin.archiving.service.eventindex.ContentEventDataProvider;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingConfigurationManager;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleActorHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleLabelHelper;
import com.midori.confluence.plugin.archiving.service.support.DateTimeProvider;
import com.midori.confluence.plugin.archiving.service.support.reduce.DataAnonymizer;
import com.midori.confluence.plugin.archiving.web.rest.model.ContentStatus;
import com.midori.confluence.plugin.archiving.web.rest.model.ContentStatusEvent;
import com.midori.confluence.plugin.archiving.web.rest.model.ContentStatusSummary;
import com.midori.confluence.plugin.archiving.web.rest.model.ContentStatusType;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentStatusCalculator {
    private static Logger log = LoggerFactory.getLogger(ContentStatusCalculator.class);
    private ContentArchivingConfigurationManager contentArchivingConfigurationManager;
    private ContentEventDataProvider contentEventDataProvider;
    private ContentLifecycleLabelHelper contentLifecycleLabelHelper;
    private ContentLifecycleActorHelper contentLifecycleActorHelper;

    public ContentStatusCalculator(ContentArchivingConfigurationManager contentArchivingConfigurationManager, ContentEventDataProvider contentEventDataProvider, ContentLifecycleLabelHelper contentLifecycleLabelHelper, ContentLifecycleActorHelper contentLifecycleActorHelper) {
        this.contentArchivingConfigurationManager = contentArchivingConfigurationManager;
        this.contentEventDataProvider = contentEventDataProvider;
        this.contentLifecycleLabelHelper = contentLifecycleLabelHelper;
        this.contentLifecycleActorHelper = contentLifecycleActorHelper;
    }

    public ContentStatus calculateContentStatus(Page page) {
        return this.calculateContentStatus(Collections.singleton(page)).get(page);
    }

    public Map<Page, ContentStatus> calculateContentStatus(Set<Page> pages) {
        long start = DateTimeProvider.currentTimeMillis();
        String spaceKey = ModelUtils.firstElement(pages).getSpaceKey();
        ContentArchivingConfiguration config = this.contentArchivingConfigurationManager.findResolvedConfiguration(spaceKey);
        LinkedHashMap<Page, ContentStatus> contentStatuses = new LinkedHashMap<Page, ContentStatus>(pages.size());
        Map<Page, ContentView> contentViews = this.contentEventDataProvider.findPageViewEvents(pages);
        Map<Page, ContentUpdate> contentUpdates = this.contentEventDataProvider.findPageUpdateEvents(pages);
        for (Page page : pages) {
            ContentUpdate contentUpdate = contentUpdates.get(page);
            ContentView contentView = contentViews.get(page);
            ContentStatusSummary contentStatusSummary = this.calculateStatusSummary(config, page, contentUpdate, contentView);
            ContentStatus contentStatus = new ContentStatus(page.getId(), contentStatusSummary, this.convertToContentStatusEvent(contentUpdate), this.convertToContentStatusEvent(contentView));
            contentStatuses.put(page, contentStatus);
        }
        log.debug(String.format("%d page status calculated in %d ms", pages.size(), DateTimeProvider.currentTimeMillis() - start));
        return contentStatuses;
    }

    private ContentStatusSummary calculateStatusSummary(ContentArchivingConfiguration configuration, Page page, ContentUpdate contentUpdate, ContentView contentView) {
        YymmddLabelingWithAncestor expireYymmddLabelingWithAncestor;
        long contentViewAge = contentView != null ? DateTimeProvider.currentTimeMillis() - contentView.getDate().getTime() : -1L;
        long contentUpdateAge = contentUpdate != null ? DateTimeProvider.currentTimeMillis() - contentUpdate.getDate().getTime() : -1L;
        Map<String, Labeling> labelsToLabelings = this.contentLifecycleLabelHelper.getLabelsToLabelings((AbstractLabelableEntityObject)page);
        HashMap<String, Labeling> ancestorLabelsToLabelings = new HashMap<String, Labeling>();
        for (Page ancestor : page.getAncestors()) {
            ancestorLabelsToLabelings.putAll(this.contentLifecycleLabelHelper.getLabelsToLabelings((AbstractLabelableEntityObject)ancestor));
        }
        Labeling noarchiveLabeling = (Labeling)ancestorLabelsToLabelings.get("noarchive");
        if (noarchiveLabeling != null) {
            return ContentStatusSummary.createWithType(ContentStatusType.EXCLUDED).viaAncestor(noarchiveLabeling.getLabelableId()).by(noarchiveLabeling.getLabeler());
        }
        Labeling labeling = noarchiveLabeling = labelsToLabelings.containsKey("noarchive") ? labelsToLabelings.get("noarchive") : labelsToLabelings.get("noarchive-single");
        if (noarchiveLabeling != null) {
            return ContentStatusSummary.createWithType(ContentStatusType.EXCLUDED).by(noarchiveLabeling.getLabeler());
        }
        if (configuration.isPageArchivingByLabelEnabled()) {
            Labeling archiveLabeling = (Labeling)ancestorLabelsToLabelings.get("archive");
            if (archiveLabeling != null) {
                return ContentStatusSummary.createWithType(ContentStatusType.TO_BE_ARCHIVED_BY_LABEL).viaAncestor(archiveLabeling.getLabelableId()).by(archiveLabeling.getLabeler());
            }
            Labeling labeling2 = archiveLabeling = labelsToLabelings.containsKey("archive") ? labelsToLabelings.get("archive") : labelsToLabelings.get("archive-single");
            if (archiveLabeling != null) {
                return ContentStatusSummary.createWithType(ContentStatusType.TO_BE_ARCHIVED_BY_LABEL).by(archiveLabeling.getLabeler());
            }
            YymmddLabelingWithAncestor archiveYymmddLabelingWithAncestor = ContentLifecycleLabelHelper.getEarliestYymmddLabeling(labelsToLabelings, ancestorLabelsToLabelings, "archive-", "archive-single-");
            if (archiveYymmddLabelingWithAncestor != null && archiveYymmddLabelingWithAncestor.hasPassed()) {
                return ContentStatusSummary.createWithType(ContentStatusType.TO_BE_ARCHIVED_BY_LABEL).viaAncestor(archiveYymmddLabelingWithAncestor.getAncestorId()).by(archiveYymmddLabelingWithAncestor.getLabeler()).at(archiveYymmddLabelingWithAncestor.getDate());
            }
        }
        if (configuration.isPageArchivingByViewAgeEnabled() || configuration.isPageArchivingByAgeEnabled()) {
            long alertAge;
            long alertAge2;
            boolean pageArchivableByViewAge = false;
            if (configuration.isPageArchivingByViewAgeEnabled() && contentView != null && contentViewAge > (alertAge2 = configuration.getPageArchivingViewAge() * 86400000L)) {
                pageArchivableByViewAge = true;
            }
            boolean pageArchivableByAge = false;
            if (configuration.isPageArchivingByAgeEnabled() && contentUpdate != null && contentUpdateAge > (alertAge = configuration.getPageArchivingAge() * 86400000L)) {
                pageArchivableByAge = true;
            }
            if (configuration.isPageArchivingByViewAgeEnabled() && configuration.isPageArchivingByAgeEnabled() && configuration.isPageArchivingOperatorAnd()) {
                if (contentView == null) {
                    return ContentStatusSummary.createWithType(ContentStatusType.UNKNOWN_LAST_VIEW_UNAVAILABLE);
                }
                if (contentUpdate == null) {
                    return ContentStatusSummary.createWithType(ContentStatusType.UNKNOWN_LAST_UPDATE_UNAVAILABLE);
                }
                if (pageArchivableByViewAge && pageArchivableByAge) {
                    return ContentStatusSummary.createWithType(ContentStatusType.TO_BE_ARCHIVED_BY_VIEW_AGE_AND_AGE).at(contentUpdate.getDate()).forDays(configuration.getPageArchivingAge()).forDays2(configuration.getPageArchivingViewAge());
                }
            } else {
                if (configuration.isPageArchivingByAgeEnabled() && pageArchivableByAge) {
                    return ContentStatusSummary.createWithType(ContentStatusType.TO_BE_ARCHIVED_BY_AGE).at(contentUpdate.getDate()).forDays(configuration.getPageArchivingAge());
                }
                if (configuration.isPageArchivingByViewAgeEnabled() && pageArchivableByViewAge) {
                    return ContentStatusSummary.createWithType(ContentStatusType.TO_BE_ARCHIVED_BY_VIEW_AGE).at(contentUpdate.getDate()).forDays(configuration.getPageArchivingViewAge());
                }
                if (configuration.isPageArchivingByAgeEnabled() && contentUpdate == null) {
                    return ContentStatusSummary.createWithType(ContentStatusType.UNKNOWN_LAST_UPDATE_UNAVAILABLE);
                }
                if (configuration.isPageArchivingByViewAgeEnabled() && contentView == null) {
                    return ContentStatusSummary.createWithType(ContentStatusType.UNKNOWN_LAST_VIEW_UNAVAILABLE);
                }
            }
        }
        if (configuration.isPageExpirationTrackingByLabelEnabled() && (expireYymmddLabelingWithAncestor = ContentLifecycleLabelHelper.getEarliestYymmddLabeling(labelsToLabelings, ancestorLabelsToLabelings, "expire-", "expire-single-")) != null && expireYymmddLabelingWithAncestor.hasPassed()) {
            return ContentStatusSummary.createWithType(ContentStatusType.EXPIRED_BY_LABEL).viaAncestor(expireYymmddLabelingWithAncestor.getAncestorId()).by(expireYymmddLabelingWithAncestor.getLabeler()).at(expireYymmddLabelingWithAncestor.getDate());
        }
        if (configuration.isPageExpirationTrackingByAgeEnabled()) {
            if (contentUpdate != null) {
                long alertAge = configuration.getPageExpirationAlertAge() * 86400000L;
                if (contentUpdateAge > alertAge) {
                    return ContentStatusSummary.createWithType(ContentStatusType.EXPIRED_BY_AGE).at(new Date(contentUpdate.getDate().getTime() + alertAge)).forDays(configuration.getPageExpirationAlertAge());
                }
            } else {
                return ContentStatusSummary.createWithType(ContentStatusType.UNKNOWN_LAST_UPDATE_UNAVAILABLE);
            }
        }
        if (configuration.isPageViewTrackingByAgeEnabled()) {
            if (contentView != null) {
                long alertAge = configuration.getPageViewAlertAge() * 86400000L;
                if (contentViewAge > alertAge) {
                    return ContentStatusSummary.createWithType(ContentStatusType.NOT_VIEWED).at(new Date(contentView.getDate().getTime() + alertAge)).forDays(configuration.getPageViewAlertAge());
                }
            } else {
                return ContentStatusSummary.createWithType(ContentStatusType.UNKNOWN_LAST_VIEW_UNAVAILABLE);
            }
        }
        return ContentStatusSummary.createWithType(ContentStatusType.UP_TO_DATE);
    }

    private ContentStatusEvent convertToContentStatusEvent(ContentEvent contentEvent) {
        if (contentEvent != null) {
            contentEvent = DataAnonymizer.anonymizeEvent(contentEvent);
            String userDisplayName = this.contentLifecycleActorHelper.getUserDisplayName(contentEvent.getOriginatorName());
            String eventDisplayName = StringUtils.defaultString((String)contentEvent.getOriginatorName(), (String)userDisplayName);
            return new ContentStatusEvent(contentEvent.getDate(), eventDisplayName);
        }
        return null;
    }
}

