/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.midori.confluence.plugin.archiving.model.base.AbstractContentLifecycleStats;
import com.midori.confluence.plugin.archiving.model.base.SpaceAndPageCountingStats;
import java.util.HashMap;
import java.util.Map;

public class ContentViewStats
extends AbstractContentLifecycleStats
implements SpaceAndPageCountingStats {
    private static final long serialVersionUID = -4678475459532039468L;
    private Map<String, Integer> spaceKeyToNotViewedPageCount = new HashMap<String, Integer>();

    public Map<String, Integer> getSpaceKeyToNotViewedPageCount() {
        return this.spaceKeyToNotViewedPageCount;
    }

    public void addNotViewedPagesForSpace(String spaceKey, int notViewedPages) {
        this.spaceKeyToNotViewedPageCount.compute(spaceKey, (key, oldValue) -> (oldValue != null ? oldValue : 0) + notViewedPages);
    }

    public int getNotViewedPagesBySpace(String spaceKey) {
        return this.spaceKeyToNotViewedPageCount.getOrDefault(spaceKey, 0);
    }

    @JsonIgnore
    public int getNotViewedPages() {
        return this.spaceKeyToNotViewedPageCount.values().stream().mapToInt(i -> i).sum();
    }

    @Override
    @JsonIgnore
    public int getSpaceCount() {
        return (int)this.spaceKeyToNotViewedPageCount.entrySet().stream().filter(e -> (Integer)e.getValue() > 0).count();
    }

    @Override
    @JsonIgnore
    public int getPageCount() {
        return this.getNotViewedPages();
    }

    @Override
    public int getPageCountBySpace(String spaceKey) {
        return this.getNotViewedPagesBySpace(spaceKey);
    }
}

