;MIDORI = typeof(MIDORI) === "undefined" ? {} : MIDORI;

MIDORI.showQuickActionStatusFlag = function(response) {
	if (response.messageCode) {
		var type = getFlagTypeForCode(response.messageCode);
		var message = getMessageForCode(response);
		if (message) {
			require(['aui/flag'], function(flag) {
				flag({
					"type": type,
					"body": "<b>" + message[0] + "</b>" + ((message.length > 1) ? " <br>" + message[1] : ""),
					"close": (type === 'success' || type === 'info') ? "auto" : "manual"
				});
			});
		}
	}

	function getFlagTypeForCode(code) {
		if (!code) {
			// should never happen
			return "";
		}
		var typeMapping = {
			"s": "success",
			"i": "info",
			"w": "warning",
			"e": "error"
		};

		var firstCharOfCode = code[0];
		return typeMapping[firstCharOfCode];
	}

	function getMessageForCode(response) {
		var messageMapping = {
			"sdes":	[ "Email(s) were sent successfully." ],
			"edens":[ "Some emails were not sent!", response.failedEmails + " recipient(s) are disabled or have invalid email addresses." ],

			"sc":	[ "This page was confirmed as up-to-date.", "A new revision was added and the expiration period restarted." ],
			"wcre":	[ "This page was confirmed as up-to-date.", "Although a new revision was added, this page remains expired." ],
			"wcra":	[ "This page was confirmed as up-to-date.", "Although a new revision was added, this page remains marked for archiving." ],

			"so":	[ "Content owners were updated." ],

			"smfe":	[ "This page expires on the selected date." ],
			"wetd":	[ "Expiration tracking is disabled!", "Although the \"" + response.labelName + "\" label was added to this page, expiration tracking is not active in the archiving configuration applied to this space.<br>Please edit the configuration (or contact the space administrator) to enable the \"labeled with expire\" trigger, otherwise <b>this page will not expire</b>.<br><br><a href=\"" + AJS.contextPath() + "/archiving/configuration.action?key=" + AJS.params.spaceKey + "\" target=\"_blank\">Edit configuration</a>" ],
			"sue":	[ "Expiration date was removed." ],

			"smfa":	[ "This page will be archived immediately (or on the selected date)." ],
			"wad":	[ "Archiving is disabled!", "Although the \"" + response.labelName + "\" label was added to this page, page archiving is not active in the archiving configuration applied to this space.<br>Please edit the configuration (or contact the space administrator) to enable the \"labeled with archive\" trigger, otherwise <b>this page will not be archived</b>.<br><br><a href=\"" + AJS.contextPath() + "/archiving/configuration.action?key=" + AJS.params.spaceKey + "\" target=\"_blank\">Edit configuration</a>" ],
			"sua":	[ "Archiving setting was removed." ],

			"sefa":	[ "Lifecycle tracking is disabled on this page." ],
			"si":	[ "Lifecycle tracking is enabled on this page." ],

			"ena":	[ "Not permitted!", "You don't have the permission to modify the labels on this page." ]
		};

		return messageMapping[response.messageCode];
	}
};

MIDORI.getUrlParameter = function(paramName) {
	var url = window.location.search.substring(1);
	var nameValuePairs = url.split('&');
	for (var i = 0; i < nameValuePairs.length; i++) {
		var nameValueArray = nameValuePairs[i].split('=');
		if (nameValueArray[0] === paramName) {
			return nameValueArray[1];
		}
	}
};

MIDORI.createPicker = function(placeholder, restRelativeUrl, multiple, formatResultRaw, formatSelectionRaw, initialDataProvider) {
	return function(inputElement, enabledByDefault) {
		// see: http://select2.github.io/select2/#ajax
		// AUI uses an older version of Select2:
		//   - https://stackoverflow.com/a/36786794/669897
		//   - https://community.atlassian.com/t5/Answers-Developer-Questions/How-to-correctly-use-AUI-Select2/qaq-p/484980
		var initialData = initialDataProvider ? initialDataProvider(inputElement) : null;
		var options = {
			placeholder: placeholder,
			minimumInputLength: multiple ? 3 : 0,
			multiple: multiple,
			ajax: {
				url: AJS.Meta.get("base-url") + "/rest/archiving/1.0" + restRelativeUrl,
				dataType: 'json',
				quietMillis: 250,
				data: function(term, page) {
					return {
						term: term
					};
				},
				results: function(data, page) {
					if (!multiple) {
						data.unshift({
							id: "",
							name: "None"
						});
					}
					return {
						results: data,
						more: false
					};
				}
			},
			formatResult: function(entity) {
				return '<div style="white-space: nowrap">' + formatResultRaw(entity) + '</div>';
			},
			formatSelection: function(entity) {
				return formatSelectionRaw(entity);
			}
		};
		if (initialDataProvider) {
			options["initSelection"] = function(element, callback) {
				callback(initialData);
			};
		}
		inputElement.auiSelect2(options);
		if (typeof enabledByDefault !== "undefined") {
			inputElement.auiSelect2("enable", enabledByDefault);
		}
	}
};

MIDORI.initSingleUserPicker = MIDORI.createPicker("Select one user", "/user-picker/options", false,
	function(user) {
		return user.name + ' (' + user.displayName + ')';
	}, function(user) {
		return user.name;
	}, function(select) {
		return {
			"id": select.val(),
			"name": select.val()
		};
	}
);


MIDORI.initMultiUserPicker = MIDORI.createPicker("Select one or more users", "/user-picker/options", true,
	function(user) {
		return user.name + ' (' + user.displayName + ')';
	}, function(user) {
		return user.name;
	}, function(select) {
		return select.val() ? _.map(select.val().split(","), function(username) {
			return {
				"id": username,
				"name": username
			};
		}) : []
	}
);

MIDORI.initSingleGroupPicker = MIDORI.createPicker("", "/group-picker/options", false,
	function(group) {
		return group.name;
	}, function(group) {
		return group.name || "None";
	}, function(input) {
		var groupname = input.val();
		return {
			"id": groupname,
			"name": groupname
		};
	}
);

AJS.toInit(function($) {
	(function addArchiveSpaceDecoration() {
		var isArchiveSpace = $("meta[name=midori-archive-space-flag]")[0];
		if (isArchiveSpace) {
			function findFirstElement(selectors) {
				for (var i in selectors) {
					var elem = $(selectors[i]);
					if (elem.length > 0) {
						return elem.first();
					}
				}
				console.error("Could not find page container");
				return $("<div>");
			}
			findFirstElement([
				"#rw_main .rw_content", // RefinedTheme
				".bv-content-wrapper", // Bitvoodoo Enterprise Theme
				"#maincontainer #cols-container", // Bitvoodoo Enterprise Theme  <= 5.2.0
				".brikit-content-layer", // Brikit Theme Press
				"#main" // default theme
			]).addClass("midori-archive");
		}

		function endsWith(subject, suffix) { // needed because IE does not support String.endsWith()
			subject = subject || "";
			suffix = suffix || "";
			return subject.indexOf(suffix, subject.length - suffix.length) !== -1;
		}
	})();
});
