/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.util.limited;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.NotImplementedException;

public class LimitedMap<K, V>
implements Map<K, V> {
    private Map<K, V> map;
    private int maxSize;
    private int nonLimitedSize;

    public LimitedMap(Map<K, V> map, int maxSize) {
        this.map = map;
        this.maxSize = maxSize;
    }

    public int getNonLimitedSize() {
        return this.nonLimitedSize;
    }

    public int getRemainingCount() {
        return this.nonLimitedSize <= this.map.size() ? 0 : this.nonLimitedSize - this.map.size();
    }

    public boolean hasRemaining() {
        return this.getRemainingCount() > 0;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public V put(K key, V value) {
        V previousValue = null;
        if (this.map.size() < this.maxSize) {
            previousValue = this.map.put(key, value);
            if (previousValue == null) {
                ++this.nonLimitedSize;
            }
        } else if (!this.map.containsKey(key)) {
            ++this.nonLimitedSize;
        }
        return previousValue;
    }

    @Override
    public V remove(Object key) {
        throw new NotImplementedException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m4) {
        throw new NotImplementedException();
    }

    @Override
    public void clear() {
        this.map.clear();
        this.nonLimitedSize = 0;
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    public String toString() {
        return String.format("size:%d, maxSize:%d, nonLimitedSize:%d, %s", this.map.size(), this.maxSize, this.nonLimitedSize, this.map);
    }
}

