/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.util.limited;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.NotImplementedException;

public class LimitedList<E>
implements List<E> {
    private List<E> list;
    private int maxSize;
    private int nonLimitedSize;

    public LimitedList(List<E> list, int maxSize) {
        this.list = list;
        this.maxSize = maxSize;
    }

    public int getNonLimitedSize() {
        return this.nonLimitedSize;
    }

    public int getRemainingCount() {
        return this.nonLimitedSize <= this.list.size() ? 0 : this.nonLimitedSize - this.list.size();
    }

    public boolean hasRemaining() {
        return this.getRemainingCount() > 0;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public void clear() {
        this.list.clear();
        this.nonLimitedSize = 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.list.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.list.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.list.toArray(a);
    }

    @Override
    public boolean add(E e) {
        boolean changed = false;
        if (this.list.size() < this.maxSize) {
            changed = this.list.add(e);
            if (changed) {
                ++this.nonLimitedSize;
            }
        } else {
            ++this.nonLimitedSize;
        }
        return changed;
    }

    @Override
    public boolean remove(Object o) {
        throw new NotImplementedException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new NotImplementedException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (E e : c) {
            this.add(e);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new NotImplementedException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new NotImplementedException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new NotImplementedException();
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public E set(int index, E element) {
        return this.list.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        throw new NotImplementedException();
    }

    @Override
    public E remove(int index) {
        throw new NotImplementedException();
    }

    @Override
    public int indexOf(Object o) {
        return this.list.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.list.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.list.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.list.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.list.subList(fromIndex, toIndex);
    }

    public String toString() {
        return String.format("size:%d, maxSize:%d, nonLimitedSize:%d, %s", this.list.size(), this.maxSize, this.nonLimitedSize, this.list);
    }
}

