/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.task.result;

import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.model.type.ContentArchivingStrategyType;
import java.io.Serializable;

public class AggregatedContentArchivingConfiguration
implements Serializable {
    private static final long serialVersionUID = -1556599028377591342L;
    private boolean pageViewTrackingOfAnyTypeEnabled = false;
    private boolean pageExpirationTrackingOfAnyTypeEnabled = false;
    private boolean pageArchivingOfAnyTypeEnabled = false;
    private boolean copyAndTrashStrategyEnabled = false;
    private boolean moveStrategyEnabled = false;
    private boolean trashStrategyEnabled = false;

    public static AggregatedContentArchivingConfiguration allDisabled() {
        return new AggregatedContentArchivingConfiguration();
    }

    public void merge(ContentArchivingConfiguration other) {
        this.pageViewTrackingOfAnyTypeEnabled = this.pageViewTrackingOfAnyTypeEnabled || other.isPageViewTrackingOfAnyTypeEnabled();
        this.pageExpirationTrackingOfAnyTypeEnabled = this.pageExpirationTrackingOfAnyTypeEnabled || other.isPageExpirationTrackingOfAnyTypeEnabled();
        this.pageArchivingOfAnyTypeEnabled = this.pageArchivingOfAnyTypeEnabled || other.isPageArchivingOfAnyTypeEnabled();
        this.copyAndTrashStrategyEnabled = this.copyAndTrashStrategyEnabled || other.getArchivingStrategyType().equals((Object)ContentArchivingStrategyType.COPY_AND_TRASH);
        this.moveStrategyEnabled = this.moveStrategyEnabled || other.getArchivingStrategyType().equals((Object)ContentArchivingStrategyType.MOVE);
        this.trashStrategyEnabled = this.trashStrategyEnabled || other.getArchivingStrategyType().equals((Object)ContentArchivingStrategyType.TRASH);
    }

    public boolean isPageViewTrackingOfAnyTypeEnabled() {
        return this.pageViewTrackingOfAnyTypeEnabled;
    }

    public boolean isPageExpirationTrackingOfAnyTypeEnabled() {
        return this.pageExpirationTrackingOfAnyTypeEnabled;
    }

    public boolean isPageArchivingOfAnyTypeEnabled() {
        return this.pageArchivingOfAnyTypeEnabled;
    }

    public boolean isCopyAndTrashStrategyEnabled() {
        return this.copyAndTrashStrategyEnabled;
    }

    public boolean isMoveStrategyEnabled() {
        return this.moveStrategyEnabled;
    }

    public boolean isTrashStrategyEnabled() {
        return this.trashStrategyEnabled;
    }
}

