/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.task.base;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.midori.confluence.plugin.archiving.service.ContentArchivingManager;
import com.midori.confluence.plugin.archiving.service.exception.ArchivingActorException;
import com.midori.confluence.plugin.archiving.service.exception.ArchivingActorInvalidException;
import com.midori.confluence.plugin.archiving.service.exception.ArchivingActorNotFoundException;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleActorHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleStatusHelper;
import com.midori.confluence.plugin.archiving.service.support.DateTimeProvider;
import com.midori.confluence.plugin.archiving.service.support.PluginHelper;
import com.midori.confluence.plugin.archiving.service.support.SpaceHelper;
import com.midori.confluence.plugin.archiving.service.support.SqlHelper;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskManager;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskResultManager;
import com.midori.confluence.plugin.archiving.service.task.base.AbstractArchivingLongRunningTask;
import com.midori.confluence.plugin.archiving.service.task.base.AbstractPageCountingLongRunningTask;
import com.midori.confluence.plugin.archiving.service.task.base.LongRunningTaskStep;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpaceOrientedLongRunningTask
extends AbstractPageCountingLongRunningTask {
    private static Logger log = LoggerFactory.getLogger(AbstractPageCountingLongRunningTask.class);
    protected ProgressTrackerGranularity progressTrackerGranularity = ProgressTrackerGranularity.SPACE;

    public AbstractSpaceOrientedLongRunningTask(PageManager pageManager, SpaceManager spaceManager, TransactionTemplate transactionTemplate, ContentLifecycleLongRunningTaskManager contentLifecycleLongRunningTaskManager, ContentArchivingManager contentArchivingManager, ContentLifecycleActorHelper contentLifecycleActorHelper, ContentLifecycleStatusHelper contentLifecycleStatusHelper, ContentLifecycleLongRunningTaskResultManager contentLifecycleLongRunningTaskResultManager, PluginHelper pluginHelper, SpaceHelper spaceHelper, SqlHelper sqlHelper, Optional<Space> space, String nodeName) {
        super(pageManager, spaceManager, transactionTemplate, contentLifecycleLongRunningTaskManager, contentArchivingManager, contentLifecycleActorHelper, contentLifecycleStatusHelper, contentLifecycleLongRunningTaskResultManager, pluginHelper, spaceHelper, sqlHelper, space, nodeName);
    }

    @Override
    protected final void executeInternal(List<Space> spaces, int totalNumberOfPages) {
        int totalSpaceCount = spaces.size();
        log.debug(String.format("Executing %s task on %d spaces (%d pages)", this.getName(), totalSpaceCount, totalNumberOfPages));
        this.beforeExecution(spaces, totalNumberOfPages);
        AbstractArchivingLongRunningTask.ClusterWideProgressTracker progressTracker = this.getClusterWideProgressTracker();
        if (this.progressTrackerGranularity == ProgressTrackerGranularity.SPACE) {
            progressTracker.setTotalObjects(spaces.size());
        }
        int spaceIndex = 0;
        for (Space space : spaces) {
            int spaceIndexFinal = ++spaceIndex;
            try {
                this.contentLifecycleActorHelper.withArchivingActor(space, spaceInternal -> {
                    for (LongRunningTaskStep longRunningTaskStep : this.getSteps()) {
                        if (longRunningTaskStep.shouldBeExecuted((Space)spaceInternal)) {
                            this.transactionTemplate.execute(() -> {
                                long start = DateTimeProvider.currentTimeMillis();
                                log.debug(String.format("Executing <%s/%s> step on <%s> (%d of %d spaces)", this.getName(), step.getName(), spaceInternal.getKey(), spaceIndexFinal, spaces.size()));
                                Space spaceReloaded = this.spaceManager.getSpace(spaceInternal.getKey());
                                step.execute(spaceReloaded, totalSpaceCount, spaceIndexFinal, progressTracker);
                                log.debug(String.format("<%s/%s> step completed on <%s> in %d ms", this.getName(), step.getName(), spaceInternal.getKey(), DateTimeProvider.currentTimeMillis() - start));
                                return null;
                            });
                            continue;
                        }
                        log.debug(String.format("Skipping <%s/%s> step on <%s> (%d of %d spaces)", this.getName(), longRunningTaskStep.getName(), spaceInternal.getKey(), spaceIndexFinal, spaces.size()));
                    }
                    return null;
                });
            }
            catch (ArchivingActorNotFoundException ex) {
                log.warn(String.format("Failed to find any actor for <%s>, skipping task for this space", space.getKey()));
            }
            catch (ArchivingActorInvalidException ex) {
                log.warn(String.format("Actor <%s> selected for <%s> is not available (deleted, disabled or permissions removed), skipping task for this space", ex.getActor(), space.getKey()));
            }
            catch (ArchivingActorException ex) {
                log.warn(String.format("Failed to authenticate actor <%s> for <%s>, skipping task for this space", ex.getActor(), space.getKey()));
            }
            if (this.progressTrackerGranularity != ProgressTrackerGranularity.SPACE || spaceIndex >= totalSpaceCount) continue;
            progressTracker.incrementCurrentCount();
        }
        this.transactionTemplate.execute(() -> {
            ArrayList<Space> spacesReloaded = new ArrayList<Space>(spaces.size());
            for (Space space : spaces) {
                spacesReloaded.add(this.spaceManager.getSpace(space.getKey()));
            }
            this.afterExecution(spacesReloaded);
            return null;
        });
        progressTracker.setPercentage(100);
        log.debug(String.format("%s task completed on %d spaces", this.getName(), totalSpaceCount));
    }

    protected abstract void beforeExecution(List<Space> var1, int var2);

    protected abstract List<? extends LongRunningTaskStep> getSteps();

    protected abstract void afterExecution(List<Space> var1);

    protected static enum ProgressTrackerGranularity {
        PAGE,
        SPACE;

    }
}

