/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support;

import com.atlassian.confluence.core.AbstractLabelableEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.labels.SpaceLabelManager;
import com.atlassian.confluence.labels.service.AddLabelsCommand;
import com.atlassian.confluence.labels.service.LabelsService;
import com.atlassian.confluence.labels.service.RemoveLabelCommand;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableSortedSet;
import com.midori.confluence.plugin.archiving.model.util.Labeling;
import com.midori.confluence.plugin.archiving.model.util.YymmddLabeling;
import com.midori.confluence.plugin.archiving.model.util.YymmddLabelingWithAncestor;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleActorHelper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentLifecycleLabelHelper {
    private static Logger log = LoggerFactory.getLogger(ContentLifecycleLabelHelper.class);
    public static final String OWNED_SINGLE_BY_USER_LABEL_PREFIX = "owned-single-by-";
    public static final String OWNED_BY_USER_LABEL_PREFIX = "owned-by-";
    public static final String EXPIRE_YYMMDD_TREE_LABEL_PREFIX = "expire-";
    public static final String EXPIRE_YYMMDD_SINGLE_LABEL_PREFIX = "expire-single-";
    public static final String ARCHIVE_TREE_LABEL_NAME = "archive";
    public static final String ARCHIVE_SINGLE_LABEL_NAME = "archive-single";
    public static final String ARCHIVE_YYMMDD_TREE_LABEL_PREFIX = "archive-";
    public static final String ARCHIVE_YYMMDD_SINGLE_LABEL_PREFIX = "archive-single-";
    public static final String ARCHIVE_REVIEW_LABEL_NAME = "archive-review";
    public static final String ARCHIVE_UPDATE_LABEL_NAME = "archive-update";
    public static final String NOARCHIVE_TREE_LABEL_NAME = "noarchive";
    public static final String NOARCHIVE_SINGLE_LABEL_NAME = "noarchive-single";
    public static final String NOARCHIVE_SPACE_LABEL_NAME = "noarchive";
    public static final SimpleDateFormat LABEL_DATE_FORMAT = new SimpleDateFormat("yy/MM/dd");
    public static final String LABEL_DATE_REGEX = "\\d{2}\\/\\d{1,2}\\/\\d{1,2}";
    public static final String LABEL_USER_NAME_REGEX = "\\S+";
    public static final String[] ALL_OWNED_BY_LABEL_PATTERNS = new String[]{"owned-single-by-\\S+", "owned-by-\\S+"};
    public static final String[] ALL_EXPIRE_LABEL_PATTERNS = new String[]{"expire-\\d{2}\\/\\d{1,2}\\/\\d{1,2}", "expire-single-\\d{2}\\/\\d{1,2}\\/\\d{1,2}"};
    public static final String[] ALL_ARCHIVE_LABEL_PATTERNS = new String[]{"archive", "archive-single", "archive-\\d{2}\\/\\d{1,2}\\/\\d{1,2}", "archive-single-\\d{2}\\/\\d{1,2}\\/\\d{1,2}"};
    public static final String[] ALL_NOARCHIVE_LABEL_PATTERNS = new String[]{"noarchive", "noarchive-single"};
    private static SortedSet<Character> INVALID_LABEL_CHARACTERS = ImmutableSortedSet.of((Comparable)Character.valueOf(':'), (Comparable)Character.valueOf(';'), (Comparable)Character.valueOf(','), (Comparable)Character.valueOf('.'), (Comparable)Character.valueOf(' '), (Comparable)Character.valueOf('?'), (Comparable[])new Character[]{Character.valueOf('&'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('#'), Character.valueOf('^'), Character.valueOf('*'), Character.valueOf('@'), Character.valueOf('!'), Character.valueOf('<'), Character.valueOf('>')});
    private static Pattern ESCAPED_LABEL_FRAGMENT_PATTERN = Pattern.compile("\\+(\\d+)\\+");
    private LabelManager labelManager;
    private LabelsService labelsService;
    private SpaceLabelManager spaceLabelManager;
    private ContentLifecycleActorHelper contentLifecycleActorHelper;

    public ContentLifecycleLabelHelper(LabelManager labelManager, LabelsService labelsService, SpaceLabelManager spaceLabelManager, ContentLifecycleActorHelper contentLifecycleActorHelper) {
        this.labelManager = labelManager;
        this.labelsService = labelsService;
        this.spaceLabelManager = spaceLabelManager;
        this.contentLifecycleActorHelper = contentLifecycleActorHelper;
    }

    public static String escapeLabelName(String input) {
        return Arrays.stream(input.split("")).filter(token -> !token.isEmpty()).map(token -> Character.valueOf(token.charAt(0))).map(character -> INVALID_LABEL_CHARACTERS.contains(character) ? String.format("+%d+", character.charValue()) : character).map(x$0 -> String.valueOf(x$0)).collect(Collectors.joining(""));
    }

    public static String unescapeLabelName(String input) {
        Matcher m4 = ESCAPED_LABEL_FRAGMENT_PATTERN.matcher(input);
        while (m4.find()) {
            try {
                input = input.replace(m4.group(), String.valueOf((char)Integer.parseInt(m4.group(1))));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return input;
    }

    public boolean hasLabelWithPattern(Page page, String ... labelPatterns) {
        for (Label label : page.getLabels()) {
            for (String labelPattern : labelPatterns) {
                if (!label.getName().matches(labelPattern)) continue;
                return true;
            }
        }
        return false;
    }

    public Collection<Label> addLabelToPage(User user, long pageId, String labelName) {
        AddLabelsCommand command = this.labelsService.newAddLabelCommand(labelName, user, pageId);
        if (!command.isAuthorized() || !command.isValid()) {
            return null;
        }
        command.execute();
        return command.getAddedLabels();
    }

    public Collection<String> removeLabelFromPage(User user, long pageId, String labelName) {
        RemoveLabelCommand command = this.labelsService.newRemoveLabelCommand(labelName, user, pageId);
        if (!command.isAuthorized() || !command.isValid()) {
            return null;
        }
        command.execute();
        return command.getRemovedLabels();
    }

    public static boolean isBlacklistedSpace(Space space) {
        return ContentLifecycleLabelHelper.findSpaceLabel(space, "noarchive") != null;
    }

    public void setSpaceBlacklistState(Space space, boolean shouldBeBlacklisted) {
        if (shouldBeBlacklisted) {
            this.blacklistSpace(space);
        } else {
            this.unblacklistSpace(space);
        }
    }

    private void blacklistSpace(Space space) {
        if (!ContentLifecycleLabelHelper.isBlacklistedSpace(space)) {
            this.spaceLabelManager.addLabel(space, "noarchive");
        }
    }

    private void unblacklistSpace(Space space) {
        Label label = ContentLifecycleLabelHelper.findSpaceLabel(space, "noarchive");
        if (label != null) {
            this.labelManager.removeLabel((Labelable)space.getDescription(), label);
        }
    }

    private static Label findSpaceLabel(Space space, String labelName) {
        SpaceDescription description = space.getDescription();
        if (description == null) {
            log.warn(String.format("Space <%s> description object is NULL due to slightly corrupt space data! See this article for an easy fix: http://bit.ly/2jUhn4G", space.getKey()));
            return null;
        }
        List spaceCategoryLabels = description.getLabels();
        for (Label label : spaceCategoryLabels) {
            if (!labelName.equals(label.getName())) continue;
            return label;
        }
        return null;
    }

    public static boolean isBlacklisterSpaceLabel(Label spaceLabel) {
        return spaceLabel.getName().equals("noarchive");
    }

    public static boolean isRecursiveLabel(String labelName) {
        return !StringUtils.contains((CharSequence)labelName, (CharSequence)"-single");
    }

    public Map<String, Labeling> getLabelsToLabelings(AbstractLabelableEntityObject labelable) {
        HashMap<String, Labeling> labelsToLabelings = new HashMap<String, Labeling>();
        for (Labelling labelling : labelable.getLabellings()) {
            String labelName = labelling.getLabel().getName();
            String labeler = this.contentLifecycleActorHelper.getUserName(labelling.getOwningUser());
            labelsToLabelings.put(labelName, new Labeling(labelable.getId(), labelName, labeler));
        }
        return labelsToLabelings;
    }

    public static YymmddLabeling getEarliestYymmddLabeling(Map<String, Labeling> labelsToLabelings, String labelPrefixTree, String labelPrefixSingle) {
        Labeling earliestLabeling = null;
        Date earliestDate = null;
        for (String label : labelsToLabelings.keySet()) {
            Date labelDate = ContentLifecycleLabelHelper.parseDateFromLabel(label, labelPrefixTree, labelPrefixSingle);
            if (labelDate == null || earliestDate != null && labelDate.getTime() >= earliestDate.getTime()) continue;
            earliestDate = labelDate;
            earliestLabeling = labelsToLabelings.get(label);
        }
        return earliestLabeling != null ? new YymmddLabeling(earliestLabeling.getLabelableId(), earliestLabeling.getLabelName(), earliestLabeling.getLabeler(), earliestDate) : null;
    }

    public static YymmddLabelingWithAncestor getEarliestYymmddLabeling(Map<String, Labeling> labelsToLabelings, Map<String, Labeling> ancestorLabelsToLabelings, String labelPrefixTree, String labelPrefixSingle) {
        YymmddLabeling earliestYymmddLabeling = ContentLifecycleLabelHelper.getEarliestYymmddLabeling(labelsToLabelings, labelPrefixTree, labelPrefixSingle);
        YymmddLabeling earliestAncestorYymmddlabeling = ContentLifecycleLabelHelper.getEarliestYymmddLabeling(ancestorLabelsToLabelings, labelPrefixTree, null);
        YymmddLabeling earliestOverallYymmddlabeling = null;
        Long ancestorId = null;
        if (earliestYymmddLabeling != null) {
            earliestOverallYymmddlabeling = earliestYymmddLabeling;
            ancestorId = null;
        }
        if (earliestAncestorYymmddlabeling != null && (earliestYymmddLabeling == null || earliestAncestorYymmddlabeling.getDate().before(earliestYymmddLabeling.getDate()))) {
            earliestOverallYymmddlabeling = earliestAncestorYymmddlabeling;
            ancestorId = earliestAncestorYymmddlabeling.getLabelableId();
        }
        return earliestOverallYymmddlabeling != null ? new YymmddLabelingWithAncestor(earliestOverallYymmddlabeling.getLabelableId(), earliestOverallYymmddlabeling.getLabelName(), earliestOverallYymmddlabeling.getLabeler(), earliestOverallYymmddlabeling.getDate(), ancestorId) : null;
    }

    public static Set<String> getUserNamesFromPageLabels(Page page, String labelPrefix) {
        return page.getLabels().stream().map(label -> ContentLifecycleLabelHelper.parseUserNameFromLabel(label.getName(), labelPrefix)).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Date parseDateFromLabel(String labelName, String ... labelPrefixesToCheck) {
        String dateString;
        String prefixFound = null;
        for (String prefixToCheck : labelPrefixesToCheck) {
            if (!StringUtils.startsWith((CharSequence)labelName, (CharSequence)prefixToCheck) || !StringUtils.isNumericSpace((CharSequence)StringUtils.substringAfter((String)labelName, (String)prefixToCheck).replace('/', ' '))) continue;
            prefixFound = prefixToCheck;
            break;
        }
        if (prefixFound != null && StringUtils.isNotBlank((CharSequence)(dateString = StringUtils.trimToNull((String)StringUtils.substringAfter((String)labelName, prefixFound))))) {
            try {
                Date expiryDate = LABEL_DATE_FORMAT.parse(dateString);
                return expiryDate;
            }
            catch (ParseException ex) {
                log.warn(String.format("Date part in label <%s> cannot be recognized (should be: \"expire-14/1/30\" or \"expire-single-14/1/30\")", labelName));
            }
        }
        return null;
    }

    public static String parseUserNameFromLabel(String labelName, String ... labelPrefixesToCheck) {
        for (String prefixToCheck : labelPrefixesToCheck) {
            if (!labelName.matches(prefixToCheck + LABEL_USER_NAME_REGEX)) continue;
            return ContentLifecycleLabelHelper.unescapeLabelName(StringUtils.substringAfter((String)labelName, (String)prefixToCheck));
        }
        return null;
    }
}

