/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.strategy;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.midori.confluence.plugin.archiving.model.ContentArchivingStats;
import com.midori.confluence.plugin.archiving.model.PageArchiving;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ContentArchivingExecutionContext {
    private Space freshSpace;
    private Space archiveSpace;
    private Set<Page> freshPagesArchived = new LinkedHashSet<Page>();
    private Map<Page, PageArchiving> freshPagesSkipped = new LinkedHashMap<Page, PageArchiving>();
    private Map<Page, PageArchiving> archivePagesResulted = new LinkedHashMap<Page, PageArchiving>();
    private Set<Long> archivePageIdsProcessed = new LinkedHashSet<Long>();
    private Set<Page> archiveParentPagesCreated = new LinkedHashSet<Page>();
    private Set<Page> archiveParentPagesSynched = new LinkedHashSet<Page>();
    private Set<Page> archivePagesCreated = new LinkedHashSet<Page>();
    private Set<Page> archivePagesSynched = new LinkedHashSet<Page>();
    private Set<Page> freshPagesTrashed = new LinkedHashSet<Page>();
    private Set<String> errors = new LinkedHashSet<String>();

    public ContentArchivingExecutionContext(Space freshSpace) {
        this.freshSpace = freshSpace;
    }

    public Space getFreshSpace() {
        return this.freshSpace;
    }

    public Space getArchiveSpace() {
        return this.archiveSpace;
    }

    public void setArchiveSpace(Space archiveSpace) {
        this.archiveSpace = archiveSpace;
    }

    public Set<Page> getFreshPagesArchived() {
        return this.freshPagesArchived;
    }

    public Map<Page, PageArchiving> getFreshPagesSkipped() {
        return this.freshPagesSkipped;
    }

    public void addFreshPagesSkipped(Map<Page, PageArchiving> pages) {
        this.freshPagesSkipped.putAll(pages);
    }

    public Map<Page, PageArchiving> getArchivePagesResulted() {
        return this.archivePagesResulted;
    }

    public void addArchivePageResulted(Page page, PageArchiving pageArchiving) {
        this.archivePagesResulted.put(page, pageArchiving);
    }

    public void addArchivePageAsProcessed(Page page) {
        this.archivePageIdsProcessed.add(page.getId());
    }

    public boolean isArchivePageProcessed(Page page) {
        return this.archivePageIdsProcessed.contains(page.getId());
    }

    public void addArchiveParentCreated(Page page) {
        this.archiveParentPagesCreated.add(page);
    }

    public void addArchiveParentSynched(Page page) {
        this.archiveParentPagesSynched.add(page);
    }

    public void addArchivePageCreated(Page page) {
        this.archivePagesCreated.add(page);
    }

    public void addArchivePageSynched(Page page) {
        this.archivePagesSynched.add(page);
    }

    public Set<Page> getFreshPagesTrashed() {
        return this.freshPagesTrashed;
    }

    public void addFreshPageTrashed(Page page) {
        this.freshPagesTrashed.add(page);
    }

    public Set<String> getErrors() {
        return this.errors;
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    public boolean isSuccessful() {
        return this.errors.isEmpty();
    }

    public boolean isFailed() {
        return !this.isSuccessful();
    }

    public ContentArchivingStats toContentArchivingStats() {
        return new ContentArchivingStats(1, this.archiveParentPagesCreated.size(), this.archiveParentPagesSynched.size(), this.archivePagesCreated.size(), this.archivePagesSynched.size(), this.freshPagesSkipped.keySet().size(), this.freshPagesTrashed.size(), this.errors);
    }
}

