/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.eventindex;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.midori.confluence.plugin.archiving.model.ContentEventIndexBuild;
import com.midori.confluence.plugin.archiving.model.ao.ContentEventIndexBuildAo;
import com.midori.confluence.plugin.archiving.model.type.PageViewInitializationType;
import com.midori.confluence.plugin.archiving.service.eventindex.ContentUpdateTracker;
import com.midori.confluence.plugin.archiving.service.eventindex.ContentViewTracker;
import com.midori.confluence.plugin.archiving.service.eventindex.support.ContentEventIndexInitializerVisitor;
import com.midori.confluence.plugin.archiving.service.support.SpaceHelper;
import com.midori.confluence.plugin.archiving.service.task.progress.ProgressTracker;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import net.java.ao.DBParam;
import net.java.ao.Query;

public class ContentEventIndexer {
    private ActiveObjects ao;
    private PageManager pageManager;
    private ContentUpdateTracker contentUpdateTracker;
    private ContentViewTracker contentViewTracker;
    private SpaceHelper spaceHelper;

    public ContentEventIndexer(ActiveObjects ao, PageManager pageManager, ContentUpdateTracker contentUpdateTracker, ContentViewTracker contentViewTracker, SpaceHelper spaceHelper) {
        this.ao = ao;
        this.pageManager = pageManager;
        this.contentUpdateTracker = contentUpdateTracker;
        this.contentViewTracker = contentViewTracker;
        this.spaceHelper = spaceHelper;
    }

    public void index(Space space, PageViewInitializationType pageViewInitializationType, Date pageViewInitialDate, ProgressTracker progressTracker) {
        ContentEventIndexInitializerVisitor visitor = new ContentEventIndexInitializerVisitor(this.pageManager, this.contentUpdateTracker, this.contentViewTracker, progressTracker);
        visitor.visit(space, pageViewInitializationType, pageViewInitialDate);
    }

    public boolean isNoSpaceIndexed() {
        List<Space> spaces = this.spaceHelper.findNonBlacklistedGlobalFreshSpaces();
        for (Space space : spaces) {
            if (!this.isIndexed(space)) continue;
            return false;
        }
        return true;
    }

    public boolean isIndexed(Space space) {
        return this.getLastIndexBuildDate(space).isPresent();
    }

    public Optional<Date> getLastIndexBuildDate(Space space) {
        Optional<ContentEventIndexBuild> lastIndexBuild = this.getLastIndexBuild(space);
        return lastIndexBuild.map(ContentEventIndexBuild::getDate);
    }

    private Optional<ContentEventIndexBuild> getLastIndexBuild(Space space) {
        Query query = Query.select().where("SPACE_KEY = ?", new Object[]{space.getKey()}).order("DATE DESC").limit(1);
        ContentEventIndexBuildAo[] aos = (ContentEventIndexBuildAo[])this.ao.find(ContentEventIndexBuildAo.class, query);
        return aos.length > 0 ? Optional.of(ContentEventIndexBuild.fromAo(aos[0])) : Optional.empty();
    }

    public void saveIndexBuild(Space space) {
        DBParam[] params = new DBParam[]{new DBParam("SPACE_KEY", (Object)space.getKey()), new DBParam("DATE", (Object)new Date())};
        this.ao.create(ContentEventIndexBuildAo.class, params);
    }
}

