/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model.base;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.midori.confluence.plugin.archiving.model.Anonymizable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public abstract class ContentEvent
implements Anonymizable<ContentEvent> {
    protected static final String SERIALIZATION_DELIMITER = "|+*+|";
    protected int id;
    protected long pageId;
    protected String originatorName;
    protected Date date;

    protected ContentEvent() {
    }

    protected ContentEvent(String serialized) {
        String[] parts = StringUtils.split((String)serialized, (String)SERIALIZATION_DELIMITER);
        this.id = Integer.parseInt(parts[0]);
        this.pageId = Long.parseLong(parts[1]);
        this.date = new Date(Long.parseLong(parts[2]));
        this.originatorName = parts[3];
    }

    public int getId() {
        return this.id;
    }

    public long getPageId() {
        return this.pageId;
    }

    public String getOriginatorName() {
        return this.originatorName;
    }

    public Date getDate() {
        return this.date;
    }

    public String serialize() {
        return Joiner.on(SERIALIZATION_DELIMITER).join(this.id, this.pageId, this.date.getTime(), this.originatorName);
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.pageId, this.originatorName, this.date);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentEvent other = (ContentEvent)obj;
        return Objects.equal(this.id, other.id) && Objects.equal(this.pageId, other.pageId) && Objects.equal(this.originatorName, other.originatorName) && Objects.equal(this.date, other.date);
    }

    public String toString() {
        return String.format("Page#%d %s on %s", this.pageId, this.originatorName, this.date);
    }
}

