/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model;

import com.midori.confluence.plugin.archiving.model.ao.ContentQualityStatsAo;
import java.util.Date;

public class ContentQualityStats {
    private String spaceKey;
    private Date date;
    private int freshPages;
    private int expiredPages;
    private int notViewedPages;
    private int archivedPages;

    public static ContentQualityStats fromAo(ContentQualityStatsAo ao) {
        if (ao == null) {
            throw new IllegalArgumentException("ContentQualityStatsAo provided must not be null");
        }
        return new ContentQualityStats(ao.getSpaceKey(), ao.getDate(), ao.getFreshPages(), ao.getExpiredPages(), ao.getNotViewedPages(), ao.getArchivedPages());
    }

    public ContentQualityStats(String spaceKey, Date date, int freshPages, int expiredPages, int notViewedPages, int archivedPages) {
        this.spaceKey = spaceKey;
        this.date = date;
        this.freshPages = freshPages;
        this.expiredPages = expiredPages;
        this.notViewedPages = notViewedPages;
        this.archivedPages = archivedPages;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public Date getDate() {
        return this.date;
    }

    public int getFreshPages() {
        return this.freshPages;
    }

    public int getExpiredPages() {
        return this.expiredPages;
    }

    public int getNotViewedPages() {
        return this.notViewedPages;
    }

    public int getArchivedPages() {
        return this.archivedPages;
    }

    public String toString() {
        return String.format("%s - fresh: %d, expired: %d, not-viewed: %d, archived: %d", this.date, this.freshPages, this.expiredPages, this.notViewedPages, this.archivedPages);
    }
}

