/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model;

import com.google.common.base.Objects;
import com.midori.confluence.plugin.archiving.model.ao.ContentArchivingConfigurationAo;
import com.midori.confluence.plugin.archiving.model.base.Identifiable;
import com.midori.confluence.plugin.archiving.model.type.ContentArchivingStrategyType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class ContentArchivingConfiguration
implements Comparable<ContentArchivingConfiguration>,
Identifiable<Integer> {
    private static final long DEFAULT_PAGE_VIEW_ALERT_AGE = 200L;
    private static final long DEFAULT_PAGE_EXPIRATION_ALERT_AGE = 365L;
    private static final long DEFAULT_PAGE_ARCHIVING_VIEW_AGE = 390L;
    private static final long DEFAULT_PAGE_ARCHIVING_AGE = 400L;
    private static final ContentArchivingStrategyType DEFAULT_ARCHIVING_STRATEGY_TYPE = ContentArchivingStrategyType.MOVE;
    private Integer id;
    private String spaceKey;
    private Integer globalConfigurationId;
    private String name;
    private boolean globalRunsEnabled = false;
    private boolean pageViewTrackingByAgeEnabled = true;
    private long pageViewAlertAge = 200L;
    private boolean notifyAuthorOnPageView = false;
    private boolean notifyLastModifierOnPageView = false;
    private boolean notifyOwnersOnPageView = true;
    private boolean notifySpaceAdminsOnPageView = true;
    private boolean notifySpaceCreatorOnPageView = true;
    private boolean notifySupervisorsOnPageView = false;
    private String supervisorsOnPageView = null;
    private boolean pageExpirationTrackingByAgeEnabled = true;
    private long pageExpirationAlertAge = 365L;
    private boolean pageExpirationTrackingByLabelEnabled = true;
    private boolean notifyAuthorOnPageExpiration = true;
    private boolean notifyLastModifierOnPageExpiration = true;
    private boolean notifyOwnersOnPageExpiration = true;
    private boolean notifySpaceAdminsOnPageExpiration = true;
    private boolean notifySpaceCreatorOnPageExpiration = true;
    private boolean notifySupervisorsOnPageExpiration = false;
    private String supervisorsOnPageExpiration = null;
    private boolean pageArchivingByViewAgeEnabled = false;
    private long pageArchivingViewAge = 390L;
    private boolean pageArchivingOperatorAnd = true;
    private boolean pageArchivingByAgeEnabled = false;
    private long pageArchivingAge = 400L;
    private boolean pageArchivingByLabelEnabled = false;
    private boolean notifyAuthorOnPageArchiving = false;
    private boolean notifyLastModifierOnPageArchiving = false;
    private boolean notifyOwnersOnPageArchiving = false;
    private boolean notifySpaceAdminsOnPageArchiving = false;
    private boolean notifySpaceCreatorOnPageArchiving = false;
    private boolean notifySupervisorsOnPageArchiving = false;
    private String supervisorsOnPageArchiving = null;
    private ContentArchivingStrategyType archivingStrategyType = DEFAULT_ARCHIVING_STRATEGY_TYPE;
    private String pageArchivingActor = null;
    private boolean archiveSpaceHidden = true;
    private boolean archivingReasonRequired = false;

    public static ContentArchivingConfiguration fromAo(ContentArchivingConfigurationAo ao) {
        if (ao == null) {
            throw new IllegalArgumentException("ContentArchivingConfigurationAo provided must not be null");
        }
        return new ContentArchivingConfiguration(ao.getID(), ao.getSpaceKey(), ao.getGlobalConfigurationId(), ao.getName(), ao.getGlobalRunsEnabled(), ao.getPageViewTrackingByAgeEnabled(), ao.getPageViewAlertAge(), ao.getNotifyAuthorOnPageView(), ao.getNotifyLastModifierOnPageView(), ao.getNotifyOwnersOnPageView(), ao.getNotifySpaceAdminsOnPageView(), ao.getNotifySpaceCreatorOnPageView(), ao.getNotifySupervisorsOnPageView(), ao.getSupervisorsOnPageView(), ao.getPageExpirationTrackingByAgeEnabled(), ao.getPageExpirationAlertAge(), ao.getPageExpirationTrackingByLabelEnabled(), ao.getNotifyAuthorOnPageExpiration(), ao.getNotifyLastModifierOnPageExpiration(), ao.getNotifyOwnersOnPageExpiration(), ao.getNotifySpaceAdminsOnPageExpiration(), ao.getNotifySpaceCreatorOnPageExpiration(), ao.getNotifySupervisorsOnPageExpiration(), ao.getSupervisorsOnPageExpiration(), ao.getPageArchivingByViewAgeEnabled(), ao.getPageArchivingViewAge(), ao.getPageArchivingOperatorAnd(), ao.getPageArchivingByAgeEnabled(), ao.getPageArchivingAge(), ao.getPageArchivingByLabelEnabled(), ao.getNotifyAuthorOnPageArchiving(), ao.getNotifyLastModifierOnPageArchiving(), ao.getNotifyOwnersOnPageArchiving(), ao.getNotifySpaceAdminsOnPageArchiving(), ao.getNotifySpaceCreatorOnPageArchiving(), ao.getNotifySupervisorsOnPageArchiving(), ao.getSupervisorsOnPageArchiving(), ao.getArchivingStrategyType(), ao.getPageArchivingActor(), ao.getArchiveSpaceHidden(), ao.getArchivingReasonRequired());
    }

    public static List<ContentArchivingConfiguration> fromAo(ContentArchivingConfigurationAo[] aos) {
        ArrayList<ContentArchivingConfiguration> result = new ArrayList<ContentArchivingConfiguration>(aos.length);
        for (ContentArchivingConfigurationAo ao : aos) {
            result.add(ContentArchivingConfiguration.fromAo(ao));
        }
        return result;
    }

    public static ContentArchivingConfiguration createDefault() {
        return new ContentArchivingConfiguration();
    }

    public static ContentArchivingConfiguration createDefault(String spaceKey) {
        ContentArchivingConfiguration contentArchivingConfiguration = new ContentArchivingConfiguration();
        contentArchivingConfiguration.setSpaceKey(spaceKey);
        return contentArchivingConfiguration;
    }

    private ContentArchivingConfiguration() {
    }

    public ContentArchivingConfiguration(Integer id, String spaceKey, Integer globalConfigurationId, String name, boolean globalRunsEnabled, boolean pageViewTrackingByAgeEnabled, long pageViewAlertAge, boolean notifyAuthorOnPageView, boolean notifyLastModifierOnPageView, boolean notifyOwnersOnPageView, boolean notifySpaceAdminsOnPageView, boolean notifySpaceCreatorOnPageView, boolean notifySupervisorsOnPageView, String supervisorsOnPageView, boolean pageExpirationTrackingByAgeEnabled, long pageExpirationAlertAge, boolean pageExpirationTrackingByLabelEnabled, boolean notifyAuthorOnPageExpiration, boolean notifyLastModifierOnPageExpiration, boolean notifyOwnersOnPageExpiration, boolean notifySpaceAdminsOnPageExpiration, boolean notifySpaceCreatorOnPageExpiration, boolean notifySupervisorsOnPageExpiration, String supervisorsOnPageExpiration, boolean pageArchivingByViewAgeEnabled, long pageArchivingViewAge, boolean pageArchivingOperatorAnd, boolean pageArchivingByAgeEnabled, long pageArchivingAge, boolean pageArchivingByLabelEnabled, boolean notifyAuthorOnPageArchiving, boolean notifyLastModifierOnPageArchiving, boolean notifyOwnersOnPageArchiving, boolean notifySpaceAdminsOnPageArchiving, boolean notifySpaceCreatorOnPageArchiving, boolean notifySupervisorsOnPageArchiving, String supervisorsOnPageArchiving, ContentArchivingStrategyType archivingStrategyType, String pageArchivingActor, boolean archiveSpaceHidden, boolean archivingReasonRequired) {
        this.id = id;
        this.spaceKey = spaceKey;
        this.globalConfigurationId = globalConfigurationId;
        this.name = name;
        this.globalRunsEnabled = globalRunsEnabled;
        this.pageViewTrackingByAgeEnabled = pageViewTrackingByAgeEnabled;
        this.pageViewAlertAge = pageViewAlertAge;
        this.notifyAuthorOnPageView = notifyAuthorOnPageView;
        this.notifyLastModifierOnPageView = notifyLastModifierOnPageView;
        this.notifyOwnersOnPageView = notifyOwnersOnPageView;
        this.notifySpaceAdminsOnPageView = notifySpaceAdminsOnPageView;
        this.notifySpaceCreatorOnPageView = notifySpaceCreatorOnPageView;
        this.notifySupervisorsOnPageView = notifySupervisorsOnPageView;
        this.supervisorsOnPageView = supervisorsOnPageView;
        this.pageExpirationTrackingByAgeEnabled = pageExpirationTrackingByAgeEnabled;
        this.pageExpirationAlertAge = pageExpirationAlertAge;
        this.pageExpirationTrackingByLabelEnabled = pageExpirationTrackingByLabelEnabled;
        this.notifyAuthorOnPageExpiration = notifyAuthorOnPageExpiration;
        this.notifyLastModifierOnPageExpiration = notifyLastModifierOnPageExpiration;
        this.notifyOwnersOnPageExpiration = notifyOwnersOnPageExpiration;
        this.notifySpaceAdminsOnPageExpiration = notifySpaceAdminsOnPageExpiration;
        this.notifySpaceCreatorOnPageExpiration = notifySpaceCreatorOnPageExpiration;
        this.notifySupervisorsOnPageExpiration = notifySupervisorsOnPageExpiration;
        this.supervisorsOnPageExpiration = supervisorsOnPageExpiration;
        this.pageArchivingByViewAgeEnabled = pageArchivingByViewAgeEnabled;
        this.pageArchivingViewAge = pageArchivingViewAge;
        this.pageArchivingOperatorAnd = pageArchivingOperatorAnd;
        this.pageArchivingByAgeEnabled = pageArchivingByAgeEnabled;
        this.pageArchivingAge = pageArchivingAge;
        this.pageArchivingByLabelEnabled = pageArchivingByLabelEnabled;
        this.notifyAuthorOnPageArchiving = notifyAuthorOnPageArchiving;
        this.notifyLastModifierOnPageArchiving = notifyLastModifierOnPageArchiving;
        this.notifyOwnersOnPageArchiving = notifyOwnersOnPageArchiving;
        this.notifySpaceAdminsOnPageArchiving = notifySpaceAdminsOnPageArchiving;
        this.notifySpaceCreatorOnPageArchiving = notifySpaceCreatorOnPageArchiving;
        this.notifySupervisorsOnPageArchiving = notifySupervisorsOnPageArchiving;
        this.supervisorsOnPageArchiving = supervisorsOnPageArchiving;
        this.archivingStrategyType = archivingStrategyType;
        this.pageArchivingActor = pageArchivingActor;
        this.archiveSpaceHidden = archiveSpaceHidden;
        this.archivingReasonRequired = archivingReasonRequired;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public Integer getGlobalConfigurationId() {
        return this.globalConfigurationId;
    }

    public void setGlobalConfigurationId(Integer globalConfigurationId) {
        this.globalConfigurationId = globalConfigurationId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isGlobalRunsEnabled() {
        return this.globalRunsEnabled;
    }

    public void setGlobalRunsEnabled(boolean globalRunsEnabled) {
        this.globalRunsEnabled = globalRunsEnabled;
    }

    public boolean isPageViewTrackingByAgeEnabled() {
        return this.pageViewTrackingByAgeEnabled;
    }

    public void setPageViewTrackingByAgeEnabled(boolean pageViewTrackingByAgeEnabled) {
        this.pageViewTrackingByAgeEnabled = pageViewTrackingByAgeEnabled;
    }

    public long getPageViewAlertAge() {
        return this.pageViewAlertAge;
    }

    public void setPageViewAlertAge(long pageViewAlertAge) {
        this.pageViewAlertAge = pageViewAlertAge;
    }

    public boolean isNotifyAuthorOnPageView() {
        return this.notifyAuthorOnPageView;
    }

    public void setNotifyAuthorOnPageView(boolean notifyAuthorOnPageView) {
        this.notifyAuthorOnPageView = notifyAuthorOnPageView;
    }

    public boolean isNotifyLastModifierOnPageView() {
        return this.notifyLastModifierOnPageView;
    }

    public void setNotifyLastModifierOnPageView(boolean notifyLastModifierOnPageView) {
        this.notifyLastModifierOnPageView = notifyLastModifierOnPageView;
    }

    public boolean isNotifyOwnersOnPageView() {
        return this.notifyOwnersOnPageView;
    }

    public void setNotifyOwnersOnPageView(boolean notifyOwnersOnPageView) {
        this.notifyOwnersOnPageView = notifyOwnersOnPageView;
    }

    public boolean isNotifySpaceAdminsOnPageView() {
        return this.notifySpaceAdminsOnPageView;
    }

    public void setNotifySpaceAdminsOnPageView(boolean notifySpaceAdminsOnPageView) {
        this.notifySpaceAdminsOnPageView = notifySpaceAdminsOnPageView;
    }

    public boolean isNotifySpaceCreatorOnPageView() {
        return this.notifySpaceCreatorOnPageView;
    }

    public void setNotifySpaceCreatorOnPageView(boolean notifySpaceCreatorOnPageView) {
        this.notifySpaceCreatorOnPageView = notifySpaceCreatorOnPageView;
    }

    public boolean isNotifySupervisorsOnPageView() {
        return this.notifySupervisorsOnPageView;
    }

    public void setNotifySupervisorsOnPageView(boolean notifySupervisorsOnPageView) {
        this.notifySupervisorsOnPageView = notifySupervisorsOnPageView;
    }

    public String getSupervisorsOnPageView() {
        return this.supervisorsOnPageView;
    }

    public void setSupervisorsOnPageView(String supervisorsOnPageView) {
        this.supervisorsOnPageView = supervisorsOnPageView;
    }

    public boolean isPageExpirationTrackingByAgeEnabled() {
        return this.pageExpirationTrackingByAgeEnabled;
    }

    public void setPageExpirationTrackingByAgeEnabled(boolean pageExpirationTrackingByAgeEnabled) {
        this.pageExpirationTrackingByAgeEnabled = pageExpirationTrackingByAgeEnabled;
    }

    public long getPageExpirationAlertAge() {
        return this.pageExpirationAlertAge;
    }

    public void setPageExpirationAlertAge(long pageExpirationAlertAge) {
        this.pageExpirationAlertAge = pageExpirationAlertAge;
    }

    public boolean isPageExpirationTrackingByLabelEnabled() {
        return this.pageExpirationTrackingByLabelEnabled;
    }

    public void setPageExpirationTrackingByLabelEnabled(boolean pageExpirationTrackingByLabelEnabled) {
        this.pageExpirationTrackingByLabelEnabled = pageExpirationTrackingByLabelEnabled;
    }

    public boolean isNotifyAuthorOnPageExpiration() {
        return this.notifyAuthorOnPageExpiration;
    }

    public void setNotifyAuthorOnPageExpiration(boolean notifyAuthorOnPageExpiration) {
        this.notifyAuthorOnPageExpiration = notifyAuthorOnPageExpiration;
    }

    public boolean isNotifyLastModifierOnPageExpiration() {
        return this.notifyLastModifierOnPageExpiration;
    }

    public void setNotifyLastModifierOnPageExpiration(boolean notifyLastModifierOnPageExpiration) {
        this.notifyLastModifierOnPageExpiration = notifyLastModifierOnPageExpiration;
    }

    public boolean isNotifyOwnersOnPageExpiration() {
        return this.notifyOwnersOnPageExpiration;
    }

    public void setNotifyOwnersOnPageExpiration(boolean notifyOwnersOnPageExpiration) {
        this.notifyOwnersOnPageExpiration = notifyOwnersOnPageExpiration;
    }

    public boolean isNotifySpaceAdminsOnPageExpiration() {
        return this.notifySpaceAdminsOnPageExpiration;
    }

    public void setNotifySpaceAdminsOnPageExpiration(boolean notifySpaceAdminsOnPageExpiration) {
        this.notifySpaceAdminsOnPageExpiration = notifySpaceAdminsOnPageExpiration;
    }

    public boolean isNotifySpaceCreatorOnPageExpiration() {
        return this.notifySpaceCreatorOnPageExpiration;
    }

    public void setNotifySpaceCreatorOnPageExpiration(boolean notifySpaceCreatorOnPageExpiration) {
        this.notifySpaceCreatorOnPageExpiration = notifySpaceCreatorOnPageExpiration;
    }

    public boolean isNotifySupervisorsOnPageExpiration() {
        return this.notifySupervisorsOnPageExpiration;
    }

    public void setNotifySupervisorsOnPageExpiration(boolean notifySupervisorsOnPageExpiration) {
        this.notifySupervisorsOnPageExpiration = notifySupervisorsOnPageExpiration;
    }

    public String getSupervisorsOnPageExpiration() {
        return this.supervisorsOnPageExpiration;
    }

    public void setSupervisorsOnPageExpiration(String supervisorsOnPageExpiration) {
        this.supervisorsOnPageExpiration = supervisorsOnPageExpiration;
    }

    public boolean isPageArchivingByViewAgeEnabled() {
        return this.pageArchivingByViewAgeEnabled;
    }

    public void setPageArchivingByViewAgeEnabled(boolean pageArchivingByViewAgeEnabled) {
        this.pageArchivingByViewAgeEnabled = pageArchivingByViewAgeEnabled;
    }

    public long getPageArchivingViewAge() {
        return this.pageArchivingViewAge;
    }

    public void setPageArchivingViewAge(long pageArchivingViewAge) {
        this.pageArchivingViewAge = pageArchivingViewAge;
    }

    public boolean isPageArchivingOperatorAnd() {
        return this.pageArchivingOperatorAnd;
    }

    public void setPageArchivingOperatorAnd(boolean pageArchivingOperatorAnd) {
        this.pageArchivingOperatorAnd = pageArchivingOperatorAnd;
    }

    public boolean isPageArchivingByAgeEnabled() {
        return this.pageArchivingByAgeEnabled;
    }

    public void setPageArchivingByAgeEnabled(boolean pageArchivingByAgeEnabled) {
        this.pageArchivingByAgeEnabled = pageArchivingByAgeEnabled;
    }

    public long getPageArchivingAge() {
        return this.pageArchivingAge;
    }

    public void setPageArchivingAge(long pageArchivingAge) {
        this.pageArchivingAge = pageArchivingAge;
    }

    public boolean isPageArchivingByLabelEnabled() {
        return this.pageArchivingByLabelEnabled;
    }

    public void setPageArchivingByLabelEnabled(boolean pageArchivingByLabelEnabled) {
        this.pageArchivingByLabelEnabled = pageArchivingByLabelEnabled;
    }

    public boolean isNotifyAuthorOnPageArchiving() {
        return this.notifyAuthorOnPageArchiving;
    }

    public void setNotifyAuthorOnPageArchiving(boolean notifyAuthorOnPageArchiving) {
        this.notifyAuthorOnPageArchiving = notifyAuthorOnPageArchiving;
    }

    public boolean isNotifyLastModifierOnPageArchiving() {
        return this.notifyLastModifierOnPageArchiving;
    }

    public void setNotifyLastModifierOnPageArchiving(boolean notifyLastModifierOnPageArchiving) {
        this.notifyLastModifierOnPageArchiving = notifyLastModifierOnPageArchiving;
    }

    public boolean isNotifyOwnersOnPageArchiving() {
        return this.notifyOwnersOnPageArchiving;
    }

    public void setNotifyOwnersOnPageArchiving(boolean notifyOwnersOnPageArchiving) {
        this.notifyOwnersOnPageArchiving = notifyOwnersOnPageArchiving;
    }

    public boolean isNotifySpaceAdminsOnPageArchiving() {
        return this.notifySpaceAdminsOnPageArchiving;
    }

    public void setNotifySpaceAdminsOnPageArchiving(boolean notifySpaceAdminsOnPageArchiving) {
        this.notifySpaceAdminsOnPageArchiving = notifySpaceAdminsOnPageArchiving;
    }

    public boolean isNotifySpaceCreatorOnPageArchiving() {
        return this.notifySpaceCreatorOnPageArchiving;
    }

    public void setNotifySpaceCreatorOnPageArchiving(boolean notifySpaceCreatorOnPageArchiving) {
        this.notifySpaceCreatorOnPageArchiving = notifySpaceCreatorOnPageArchiving;
    }

    public boolean isNotifySupervisorsOnPageArchiving() {
        return this.notifySupervisorsOnPageArchiving;
    }

    public void setNotifySupervisorsOnPageArchiving(boolean notifySupervisorsOnPageArchiving) {
        this.notifySupervisorsOnPageArchiving = notifySupervisorsOnPageArchiving;
    }

    public String getSupervisorsOnPageArchiving() {
        return this.supervisorsOnPageArchiving;
    }

    public void setSupervisorsOnPageArchiving(String supervisorsOnPageArchiving) {
        this.supervisorsOnPageArchiving = supervisorsOnPageArchiving;
    }

    public ContentArchivingStrategyType getArchivingStrategyType() {
        return this.archivingStrategyType;
    }

    public void setArchivingStrategyType(ContentArchivingStrategyType archivingStrategyType) {
        this.archivingStrategyType = archivingStrategyType;
    }

    public String getPageArchivingActor() {
        return this.pageArchivingActor;
    }

    public void setPageArchivingActor(String pageArchivingActor) {
        this.pageArchivingActor = pageArchivingActor;
    }

    public boolean isArchiveSpaceHidden() {
        return this.archiveSpaceHidden;
    }

    public void setArchiveSpaceHidden(boolean archiveSpaceHidden) {
        this.archiveSpaceHidden = archiveSpaceHidden;
    }

    public boolean isArchivingReasonRequired() {
        return this.archivingReasonRequired;
    }

    public void setArchivingReasonRequired(boolean archivingReasonRequired) {
        this.archivingReasonRequired = archivingReasonRequired;
    }

    @Override
    public int compareTo(ContentArchivingConfiguration o) {
        return this.name.compareTo(o.getName());
    }

    public boolean isGlobal() {
        return this.spaceKey == null;
    }

    public boolean isSpaceScoped() {
        return !this.isGlobal();
    }

    public boolean hasOverridingGlobalConfiguration() {
        return this.getGlobalConfigurationId() != null;
    }

    public boolean isOverriddenBy(Integer globalConfigurationId) {
        return this.getGlobalConfigurationId() != null && this.getGlobalConfigurationId().equals(globalConfigurationId);
    }

    public boolean isPageViewTrackingOfAnyTypeEnabled() {
        return this.isPageViewTrackingByAgeEnabled();
    }

    public boolean isPageExpirationTrackingOfAnyTypeEnabled() {
        return this.isPageExpirationTrackingByAgeEnabled() || this.isPageExpirationTrackingByLabelEnabled();
    }

    public boolean isPageArchivingOfAnyTypeEnabled() {
        return this.isPageArchivingByViewAgeEnabled() || this.isPageArchivingByAgeEnabled() || this.isPageArchivingByLabelEnabled();
    }

    public void sanitize() {
        if (this.isGlobal() && StringUtils.isBlank((CharSequence)this.name)) {
            this.name = "Unnamed";
        }
        this.pageViewAlertAge = this.pageViewAlertAge > 0L ? this.pageViewAlertAge : 200L;
        this.notifySupervisorsOnPageView = StringUtils.isNotBlank((CharSequence)this.supervisorsOnPageView) && this.notifySupervisorsOnPageView;
        this.pageExpirationAlertAge = this.pageExpirationAlertAge > 0L ? this.pageExpirationAlertAge : 365L;
        this.notifySupervisorsOnPageExpiration = StringUtils.isNotBlank((CharSequence)this.supervisorsOnPageExpiration) && this.notifySupervisorsOnPageExpiration;
        this.pageArchivingViewAge = this.pageArchivingViewAge > 0L ? this.pageArchivingViewAge : 390L;
        this.pageArchivingAge = this.pageArchivingAge > 0L ? this.pageArchivingAge : 400L;
        this.notifySupervisorsOnPageArchiving = StringUtils.isNotBlank((CharSequence)this.supervisorsOnPageArchiving) && this.notifySupervisorsOnPageArchiving;
        this.archivingStrategyType = this.archivingStrategyType != null ? this.archivingStrategyType : DEFAULT_ARCHIVING_STRATEGY_TYPE;
    }

    public String toString() {
        return "ContentArchivingConfiguration{id=" + this.id + ", spaceKey='" + this.spaceKey + '\'' + ", globalConfigurationId=" + this.globalConfigurationId + ", name='" + this.name + '\'' + '}';
    }

    public int hashCode() {
        return Objects.hashCode(this.id, this.spaceKey);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        ContentArchivingConfiguration other = (ContentArchivingConfiguration)o;
        return Objects.equal(this.id, other.id) && Objects.equal(this.spaceKey, other.spaceKey) && Objects.equal(this.globalConfigurationId, other.globalConfigurationId) && Objects.equal(this.name, other.name) && Objects.equal(this.globalRunsEnabled, other.globalRunsEnabled) && Objects.equal(this.pageViewTrackingByAgeEnabled, other.pageViewTrackingByAgeEnabled) && Objects.equal(this.pageViewAlertAge, other.pageViewAlertAge) && Objects.equal(this.notifyAuthorOnPageView, other.notifyAuthorOnPageView) && Objects.equal(this.notifyLastModifierOnPageView, other.notifyLastModifierOnPageView) && Objects.equal(this.notifyOwnersOnPageView, other.notifyOwnersOnPageView) && Objects.equal(this.notifySpaceAdminsOnPageView, other.notifySpaceAdminsOnPageView) && Objects.equal(this.notifySpaceCreatorOnPageView, other.notifySpaceCreatorOnPageView) && Objects.equal(this.notifySupervisorsOnPageView, other.notifySupervisorsOnPageView) && Objects.equal(this.supervisorsOnPageView, other.supervisorsOnPageView) && Objects.equal(this.pageExpirationTrackingByAgeEnabled, other.pageExpirationTrackingByAgeEnabled) && Objects.equal(this.pageExpirationAlertAge, other.pageExpirationAlertAge) && Objects.equal(this.pageExpirationTrackingByLabelEnabled, other.pageExpirationTrackingByLabelEnabled) && Objects.equal(this.notifyAuthorOnPageExpiration, other.notifyAuthorOnPageExpiration) && Objects.equal(this.notifyLastModifierOnPageExpiration, other.notifyLastModifierOnPageExpiration) && Objects.equal(this.notifyOwnersOnPageExpiration, other.notifyOwnersOnPageExpiration) && Objects.equal(this.notifySpaceAdminsOnPageExpiration, other.notifySpaceAdminsOnPageExpiration) && Objects.equal(this.notifySpaceCreatorOnPageExpiration, other.notifySpaceCreatorOnPageExpiration) && Objects.equal(this.notifySupervisorsOnPageExpiration, other.notifySupervisorsOnPageExpiration) && Objects.equal(this.supervisorsOnPageExpiration, other.supervisorsOnPageExpiration) && Objects.equal(this.pageArchivingByViewAgeEnabled, other.pageArchivingByViewAgeEnabled) && Objects.equal(this.pageArchivingViewAge, other.pageArchivingViewAge) && Objects.equal(this.pageArchivingOperatorAnd, other.pageArchivingOperatorAnd) && Objects.equal(this.pageArchivingByAgeEnabled, other.pageArchivingByAgeEnabled) && Objects.equal(this.pageArchivingAge, other.pageArchivingAge) && Objects.equal(this.pageArchivingByLabelEnabled, other.pageArchivingByLabelEnabled) && Objects.equal(this.notifyAuthorOnPageArchiving, other.notifyAuthorOnPageArchiving) && Objects.equal(this.notifyLastModifierOnPageArchiving, other.notifyLastModifierOnPageArchiving) && Objects.equal(this.notifyOwnersOnPageArchiving, other.notifyOwnersOnPageArchiving) && Objects.equal(this.notifySpaceAdminsOnPageArchiving, other.notifySpaceAdminsOnPageArchiving) && Objects.equal(this.notifySpaceCreatorOnPageArchiving, other.notifySpaceCreatorOnPageArchiving) && Objects.equal(this.notifySupervisorsOnPageArchiving, other.notifySupervisorsOnPageArchiving) && Objects.equal(this.supervisorsOnPageArchiving, other.supervisorsOnPageArchiving) && Objects.equal((Object)this.archivingStrategyType, (Object)other.archivingStrategyType) && Objects.equal(this.pageArchivingActor, other.pageArchivingActor) && Objects.equal(this.archiveSpaceHidden, other.archiveSpaceHidden) && Objects.equal(this.archivingReasonRequired, other.archivingReasonRequired);
    }
}

