/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web;

import com.atlassian.confluence.core.Beanable;
import com.atlassian.confluence.pages.Page;
import com.google.common.collect.TreeMultimap;
import com.midori.confluence.plugin.archiving.model.ContentUpdate;
import com.midori.confluence.plugin.archiving.model.base.ContentEvent;
import com.midori.confluence.plugin.archiving.service.support.reduce.DataAnonymizer;
import com.midori.confluence.plugin.archiving.web.base.AbstractArchivingAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class ViewPageListAction
extends AbstractArchivingAction
implements Beanable {
    private static final int PAGE_SIZE = 30;
    private String type;
    private long after;
    private List<Page> pages = new ArrayList<Page>(30);
    private List<String> pageDescriptions = new ArrayList<String>(30);
    private long earliestUpdateTime;
    private boolean hasMore;

    public String getType() {
        return this.type;
    }

    @StrutsParameter
    public void setType(String type) {
        this.type = type;
    }

    @StrutsParameter
    public void setAfter(long after) {
        this.after = after;
    }

    public String execute() {
        return "success";
    }

    public String page() {
        Map<Page, ContentUpdate> expiredPages;
        Map<Page, ContentEvent> unfilteredPages = null;
        if (this.type.equals("E")) {
            unfilteredPages = this.contentArchivingManager.findExpiredPages(this.getSpace());
        } else if (this.type.equals("R")) {
            expiredPages = this.contentArchivingManager.findExpiredPages(this.getSpace());
            unfilteredPages = this.contentArchivingManager.findPagesToReview(this.space, expiredPages);
        } else if (this.type.equals("U")) {
            expiredPages = this.contentArchivingManager.findExpiredPages(this.getSpace());
            unfilteredPages = this.contentArchivingManager.findPagesToUpdate(this.space, expiredPages);
        } else if (this.type.equals("V")) {
            unfilteredPages = this.contentArchivingManager.findNotViewedPages(this.getSpace());
        }
        TreeMultimap updateTimesToPages = TreeMultimap.create();
        for (Map.Entry<Page, ContentUpdate> page : unfilteredPages.entrySet()) {
            updateTimesToPages.put((Object)((ContentEvent)page.getValue()).getDate().getTime(), (Object)page.getKey());
        }
        Iterator it = updateTimesToPages.keySet().iterator();
        while (it.hasNext()) {
            Long time = (Long)it.next();
            boolean bl = this.after != 0L ? time > this.after : true;
            boolean match = bl;
            if (!match) continue;
            for (Page page : updateTimesToPages.get((Object)time)) {
                this.pages.add(page);
                ContentEvent pageEvent = unfilteredPages.get(page);
                pageEvent = DataAnonymizer.anonymizeEvent(pageEvent);
                this.pageDescriptions.add(String.format("%s by %s %s", this.getAction(pageEvent), this.getName(pageEvent), this.relativeTimeHelper.getRelativeTime(pageEvent.getDate())));
            }
            this.earliestUpdateTime = time;
            this.hasMore = it.hasNext();
            if (this.pages.size() < 30) continue;
            break;
        }
        return "success";
    }

    public Object getBean() {
        HashMap<String, Object> bean = new HashMap<String, Object>(4);
        bean.put("pages", this.pages);
        bean.put("pageDescriptions", this.pageDescriptions);
        bean.put("earliestUpdateTime", this.earliestUpdateTime);
        bean.put("hasMore", this.hasMore);
        return bean;
    }

    private String getAction(ContentEvent pageEvent) {
        return pageEvent instanceof ContentUpdate ? ((ContentUpdate)pageEvent).getUpdateAction() : "last viewed";
    }

    private String getName(ContentEvent pageEvent) {
        String name = pageEvent.getOriginatorName();
        return StringUtils.isNotBlank((String)name) ? name : this.getText("anonymous.name");
    }
}

