/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.spaces.Space;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.midori.confluence.plugin.archiving.model.ContentQualityStats;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.persistence.ContentQualityStatsManager;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleLabelHelper;
import com.midori.confluence.plugin.archiving.tool.ContentQualityStatsTool;
import com.midori.confluence.plugin.archiving.util.SpaceByNameComparator;
import com.midori.confluence.plugin.archiving.web.base.AbstractNonBlacklistedArchivingAction;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewContentQualityStatsAction
extends AbstractNonBlacklistedArchivingAction {
    private static Logger log = LoggerFactory.getLogger(ViewContentQualityStatsAction.class);
    private ContentQualityStatsManager contentQualityStatsManager;
    private ContentQualityStatsTool contentQualityStatsTool;

    public void setContentQualityStatsManager(ContentQualityStatsManager contentQualityStatsManager) {
        this.contentQualityStatsManager = contentQualityStatsManager;
    }

    public ContentQualityStatsTool getContentQualityStatsTool() {
        return this.contentQualityStatsTool;
    }

    public String execute() {
        this.contentQualityStatsTool = this.isGlobal() ? this.buildGlobalContentQualityStatsTool() : this.buildSpaceContentQualityStatsTool();
        return "success";
    }

    private ContentQualityStatsTool buildGlobalContentQualityStatsTool() {
        List<Space> allSpaces = this.spaceHelper.findNonBlacklistedGlobalFreshSpaces();
        Multimap<Space, Label> spaceLabels = this.spaceHelper.findSpacesWithTeamLabels();
        Multimap<Label, Space> spacesBySpaceCategories = ViewContentQualityStatsAction.categorizeSpacesBySpaceLabels(allSpaces, spaceLabels);
        Map<String, ContentQualityStats> statsBySpaces = this.contentQualityStatsManager.getContentQualityStatsBySpaces(ModelUtils.getSpaceKeys(spacesBySpaceCategories.values()));
        return new ContentQualityStatsTool(spacesBySpaceCategories.asMap(), statsBySpaces);
    }

    private static Multimap<Label, Space> categorizeSpacesBySpaceLabels(List<Space> spaces, Multimap<Space, Label> spaceLabels) {
        SpaceByNameComparator spaceByNameComparator = new SpaceByNameComparator();
        Multimap spaceCategoriesToSpaces = (Multimap)spaceLabels.entries().stream().filter(entry -> spaces.contains(entry.getKey())).filter(entry -> !ContentLifecycleLabelHelper.isBlacklisterSpaceLabel((Label)entry.getValue())).collect(() -> TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)spaceByNameComparator), (map, element) -> map.put((Object)((Label)element.getValue()), (Object)((Space)element.getKey())), (rec$, x$0) -> ((TreeMultimap)rec$).putAll(x$0));
        TreeSet<Space> nonCategorizedSpaces = new TreeSet<Space>(spaceByNameComparator);
        nonCategorizedSpaces.addAll(spaces);
        nonCategorizedSpaces.removeAll(spaceCategoriesToSpaces.values());
        spaceCategoriesToSpaces.putAll((Object)new Label("<uncategorised>"), nonCategorizedSpaces);
        log.debug(String.format("%d spaces categorized into %d categories", spaces.size(), spaceCategoriesToSpaces.keySet().size()));
        return spaceCategoriesToSpaces;
    }

    private ContentQualityStatsTool buildSpaceContentQualityStatsTool() {
        return new ContentQualityStatsTool(null, Collections.singletonMap(this.space.getKey(), this.contentQualityStatsManager.getContentQualityStatsBySpace(this.space.getKey())));
    }
}

