/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.task;

import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.midori.confluence.plugin.archiving.model.type.PageViewInitializationType;
import com.midori.confluence.plugin.archiving.service.ContentArchivingManager;
import com.midori.confluence.plugin.archiving.service.eventindex.ContentEventIndexer;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleActorHelper;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleStatusHelper;
import com.midori.confluence.plugin.archiving.service.support.PluginHelper;
import com.midori.confluence.plugin.archiving.service.support.SpaceHelper;
import com.midori.confluence.plugin.archiving.service.support.SqlHelper;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskManager;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskResultManager;
import com.midori.confluence.plugin.archiving.service.task.base.AbstractQualityStatsRelatedLongRunningTask;
import com.midori.confluence.plugin.archiving.service.task.base.AbstractSpaceOrientedLongRunningTask;
import com.midori.confluence.plugin.archiving.service.task.base.LongRunningTaskStep;
import com.midori.confluence.plugin.archiving.service.task.progress.ProgressTracker;
import com.midori.confluence.plugin.archiving.service.task.progress.SmartProgressMeter;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class ContentEventIndexerLongRunningTask
extends AbstractQualityStatsRelatedLongRunningTask {
    private ContentEventIndexer contentEventIndexer;
    private PageViewInitializationType pageViewInitializationType;
    private Date pageViewInitialDate;
    private LongRunningTaskStep step = new LongRunningTaskStep(){

        @Override
        public String getName() {
            return "Content Event Indexing";
        }

        @Override
        public boolean shouldBeExecuted(Space space) {
            return true;
        }

        @Override
        public void execute(Space space, int totalSpaceCount, int spaceIndex, ProgressTracker progressTracker) {
            ContentEventIndexerLongRunningTask.this.contentEventIndexer.index(space, ContentEventIndexerLongRunningTask.this.pageViewInitializationType, ContentEventIndexerLongRunningTask.this.pageViewInitialDate, progressTracker);
            ContentEventIndexerLongRunningTask.this.contentEventIndexer.saveIndexBuild(space);
        }
    };

    public ContentEventIndexerLongRunningTask(PageManager pageManager, SpaceManager spaceManager, TransactionTemplate transactionTemplate, ContentLifecycleLongRunningTaskManager contentLifecycleLongRunningTaskManager, ContentArchivingManager contentArchivingManager, ContentLifecycleActorHelper contentLifecycleActorHelper, ContentLifecycleStatusHelper contentLifecycleStatusHelper, ContentLifecycleLongRunningTaskResultManager contentLifecycleLongRunningTaskResultManager, PluginHelper pluginHelper, SpaceHelper spaceHelper, SqlHelper sqlHelper, Option<Space> space, String nodeName, ContentEventIndexer contentEventIndexer, PageViewInitializationType pageViewInitializationType, Date pageViewInitialDate) {
        super(pageManager, spaceManager, transactionTemplate, contentLifecycleLongRunningTaskManager, contentArchivingManager, contentLifecycleActorHelper, contentLifecycleStatusHelper, contentLifecycleLongRunningTaskResultManager, pluginHelper, spaceHelper, sqlHelper, space, nodeName);
        this.contentEventIndexer = contentEventIndexer;
        this.pageViewInitializationType = pageViewInitializationType;
        this.pageViewInitialDate = pageViewInitialDate;
    }

    @Override
    public String getName() {
        return "Content Event Indexing";
    }

    @Override
    protected String getStartStatusHtml() {
        return "Indexing content events...";
    }

    @Override
    protected SmartProgressMeter createProgressMeter() {
        return new SmartProgressMeter("Indexing content events (%s of %s pages)...", this.getCompletedStatusHtml());
    }

    @Override
    public String getCompletedStatusHtml() {
        return "Content event indexing completed.";
    }

    @Override
    protected String getErrorStatusHtml(Exception cause) {
        return "Failed to index content events. Please check your log files: " + cause.getMessage();
    }

    @Override
    protected String getErrorLogText() {
        return "Failed to index content events";
    }

    @Override
    protected void beforeExecution(List<Space> allSpacesToProcess, int totalNumberOfPages) {
        this.progressTrackerGranularity = AbstractSpaceOrientedLongRunningTask.ProgressTrackerGranularity.PAGE;
        this.getClusterWideProgressTracker().setTotalObjects(totalNumberOfPages);
    }

    @Override
    protected List<? extends LongRunningTaskStep> getSteps() {
        return Collections.singletonList(this.step);
    }
}

