/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support.reduce;

import com.atlassian.confluence.pages.Page;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.Date;

public class LightPage
implements Serializable {
    private long id;
    private String spaceKey;
    private String title;
    private String creatorName;
    private String lastModifierName;
    private Date creationDate;

    public static LightPage fromPage(Page page) {
        return new LightPage(page);
    }

    private LightPage(Page page) {
        this.id = page.getId();
        this.spaceKey = page.getSpaceKey();
        this.title = page.getTitle();
        this.creatorName = page.getCreator() != null ? page.getCreator().getName() : null;
        this.lastModifierName = page.getLastModifier() != null ? page.getLastModifier().getName() : null;
        this.creationDate = page.getCreationDate();
    }

    public long getId() {
        return this.id;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    @Deprecated
    public String getLastModiferName() {
        return this.lastModifierName;
    }

    public String getLastModifierName() {
        return this.lastModifierName;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.spaceKey, this.title});
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        LightPage other = (LightPage)o;
        return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.spaceKey, (Object)other.spaceKey) && Objects.equal((Object)this.title, (Object)other.title);
    }

    public String toString() {
        return String.format("LightPage #%d \"%s\"", this.id, this.title);
    }
}

