/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchConstants;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.query.PrefixQuery;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceDescription;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceStatus;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleLabelHelper;
import com.midori.confluence.plugin.archiving.util.NonBlacklistedGlobalFreshSpacePredicate;
import com.midori.confluence.plugin.archiving.web.support.ConfluenceCompatibilityHelper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceHelper {
    private static Logger log = LoggerFactory.getLogger(SpaceHelper.class);
    public static final String ARCHIVE_SPACE_KEY_SUFFIX = "Archive";
    public static final String ARCHIVE_SPACE_NAME_SUFFIX = " (Archive)";
    private SearchManager searchManager;
    private SpaceManager spaceManager;

    public SpaceHelper(SearchManager searchManager, SpaceManager spaceManager) {
        this.searchManager = searchManager;
        this.spaceManager = spaceManager;
    }

    public String getCanonicalSpaceKey(String caseInsensitiveSpaceKey) {
        if (caseInsensitiveSpaceKey != null) {
            Space space = this.spaceManager.getSpace(caseInsensitiveSpaceKey);
            return space != null ? space.getKey() : caseInsensitiveSpaceKey;
        }
        return null;
    }

    public List<Space> findNonBlacklistedGlobalFreshSpaces() {
        long start = System.currentTimeMillis();
        List<Space> spaces = this.findGlobalFreshSpaces();
        long beforeFiltering = System.currentTimeMillis();
        ArrayList<Space> filteredSpaces = new ArrayList<Space>(Collections2.filter(spaces, (Predicate)NonBlacklistedGlobalFreshSpacePredicate.INSTANCE));
        log.debug(String.format("%d non-blacklisted fresh global spaces (%d total) found in %d ms (filtering took %d ms)", filteredSpaces.size(), spaces.size(), System.currentTimeMillis() - start, System.currentTimeMillis() - beforeFiltering));
        return filteredSpaces;
    }

    public List<Space> findGlobalFreshSpaces() {
        SpacesQuery spacesQuery = SpacesQuery.newQuery().withSpaceType(SpaceType.GLOBAL).withSpaceStatus(SpaceStatus.CURRENT).build();
        ArrayList<Space> spaces = new ArrayList<Space>();
        for (List spaceList : this.spaceManager.getSpaces(spacesQuery)) {
            spaces.addAll(spaceList);
        }
        return spaces;
    }

    public static String getArchiveSpaceKeyBySpaceKey(String spaceKey) {
        return spaceKey + ARCHIVE_SPACE_KEY_SUFFIX;
    }

    public static String getArchiveSpaceNameBySpaceName(String spaceName) {
        return spaceName + ARCHIVE_SPACE_NAME_SUFFIX;
    }

    public Space findArchiveSpaceByFreshSpace(String spaceKey) {
        return this.spaceManager.getSpace(SpaceHelper.getArchiveSpaceKeyBySpaceKey(spaceKey));
    }

    public Set<Space> findBlacklistedSpaces() {
        return this.findSpacesWithTeamLabels().entries().stream().filter(entry -> ContentLifecycleLabelHelper.isBlacklisterSpaceLabel((Label)entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Multimap<Space, Label> findSpacesWithTeamLabels() {
        int offset = 0;
        int limit = 500;
        try {
            log.debug("Searching for spaces with team labels");
            long start = System.currentTimeMillis();
            ISearch search = ConfluenceCompatibilityHelper.createContentSearch((SearchQuery)new PrefixQuery("label", "team:"), null, offset, 500);
            SearchResults searchResults = this.searchManager.search(search);
            LinkedList<Searchable> allSearchResults = new LinkedList<Searchable>(this.convertToEntities(searchResults));
            int watchdog = 1000;
            while (!searchResults.isLastPage() && --watchdog > 0) {
                if ((offset += searchResults.size()) > SearchConstants.MAX_START_OFFSET) {
                    log.debug(String.format("Offset %d would exceed max allowed offset %d, stopping", offset, SearchConstants.MAX_START_OFFSET));
                    break;
                }
                log.trace(String.format("Getting search result page (offset: %d, limit: %d)", offset, 500));
                search = ConfluenceCompatibilityHelper.createContentSearch(search.getQuery(), search.getSort(), offset, 500);
                searchResults = this.searchManager.search(search);
                allSearchResults.addAll(this.convertToEntities(searchResults));
            }
            log.debug(String.format("%d total search results found", allSearchResults.size()));
            Multimap results = (Multimap)allSearchResults.stream().filter(searchable -> searchable instanceof SpaceDescription).map(searchable -> (SpaceDescription)searchable).map(spaceDescription -> {
                List filteredLabels = spaceDescription.getLabellings().stream().map(Labelling::getLabel).filter(label -> label.toStringWithNamespace().startsWith("team:")).collect(Collectors.toList());
                return new ImmutablePair((Object)spaceDescription.getSpace(), filteredLabels);
            }).filter(pair -> !((List)pair.getValue()).isEmpty()).collect(ArrayListMultimap::create, (map, element) -> map.putAll((Object)((Space)element.getKey()), (Iterable)element.getValue()), (rec$, x$0) -> ((ArrayListMultimap)rec$).putAll(x$0));
            log.debug(String.format("%d spaces with team labels found in %d ms", results.size(), System.currentTimeMillis() - start));
            return results;
        }
        catch (InvalidSearchException e) {
            log.error("Failed to search for spaces", (Throwable)e);
            return HashMultimap.create();
        }
    }

    private List<Searchable> convertToEntities(SearchResults searchResults) {
        return this.searchManager.convertToEntities(searchResults, SearchManager.EntityVersionPolicy.LATEST_VERSION);
    }
}

