/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.persistence;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.midori.confluence.plugin.archiving.model.ContentQualityStats;
import com.midori.confluence.plugin.archiving.model.ao.ContentQualityStatsAo;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentQualityStatsManager {
    private static Logger log = LoggerFactory.getLogger(ContentQualityStatsManager.class);
    private ActiveObjects ao;

    public ContentQualityStatsManager(ActiveObjects ao) {
        this.ao = ao;
    }

    public void saveContentQualityStats(final Space space, final int numberOfPages, final int numberOfExpiredPages, final int numberOfNotViewedPages, final int numberOfArchivedPages) {
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                List<DBParam> params = Arrays.asList(new DBParam("SPACE_KEY", (Object)space.getKey()), new DBParam("CALCULATION_DATE", (Object)new Date()), new DBParam("FRESH_PAGES", (Object)(numberOfPages - numberOfExpiredPages)), new DBParam("EXPIRED_PAGES", (Object)numberOfExpiredPages), new DBParam("NOT_VIEWED_PAGES", (Object)numberOfNotViewedPages), new DBParam("ARCHIVED_PAGES", (Object)numberOfArchivedPages));
                ContentQualityStatsManager.this.ao.deleteWithSQL(ContentQualityStatsAo.class, "SPACE_KEY = ?", new Object[]{space.getKey()});
                ContentQualityStatsManager.this.ao.create(ContentQualityStatsAo.class, params.toArray(new DBParam[0]));
                log.debug(String.format("Content quality stats saved for <%s>", space.getKey()));
                return null;
            }
        });
    }

    public ContentQualityStats getContentQualityStatsBySpace(final String spaceKey) {
        return (ContentQualityStats)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<ContentQualityStats>(){

            public ContentQualityStats doInTransaction() {
                ContentQualityStatsAo[] contentQualityStatsAos = (ContentQualityStatsAo[])ContentQualityStatsManager.this.ao.find(ContentQualityStatsAo.class, Query.select().where("SPACE_KEY = ?", new Object[]{spaceKey}));
                int numberOfAos = contentQualityStatsAos.length;
                if (numberOfAos > 1) {
                    throw new IllegalStateException(String.format("%d content quality stats found for space <%s> (should be 0 or 1!)", numberOfAos, spaceKey));
                }
                return numberOfAos > 0 ? ContentQualityStats.fromAo(contentQualityStatsAos[0]) : null;
            }
        });
    }

    public Map<String, ContentQualityStats> getContentQualityStatsBySpaces(final Set<String> spaceKeys) {
        final HashMap<String, ContentQualityStats> statsBySpaces = new HashMap<String, ContentQualityStats>();
        long start = System.currentTimeMillis();
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                ContentQualityStatsAo[] contentQualityStatsAos;
                for (ContentQualityStatsAo contentQualityStatsAo : contentQualityStatsAos = (ContentQualityStatsAo[])ContentQualityStatsManager.this.ao.find(ContentQualityStatsAo.class)) {
                    ContentQualityStats contentQualityStats = ContentQualityStats.fromAo(contentQualityStatsAo);
                    String spaceKey = contentQualityStats.getSpaceKey();
                    if (!spaceKeys.contains(spaceKey)) continue;
                    statsBySpaces.put(spaceKey, contentQualityStats);
                }
                return null;
            }
        });
        log.debug(String.format("Content quality statistics found for %d spaces in %d ms", spaceKeys.size(), System.currentTimeMillis() - start));
        return statsBySpaces;
    }
}

