/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.eventindex;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.midori.confluence.plugin.archiving.model.ContentUpdate;
import com.midori.confluence.plugin.archiving.model.ContentView;
import com.midori.confluence.plugin.archiving.service.eventindex.ContentEventIndexer;
import com.midori.confluence.plugin.archiving.service.eventindex.ContentUpdateTracker;
import com.midori.confluence.plugin.archiving.service.eventindex.ContentViewTracker;
import java.util.Map;
import java.util.Set;

public class ContentEventDataProvider {
    private ContentEventIndexer contentEventIndexer;
    private ContentUpdateTracker contentUpdateTracker;
    private ContentViewTracker contentViewTracker;

    public ContentEventDataProvider(ContentEventIndexer contentEventIndexer, ContentUpdateTracker contentUpdateTracker, ContentViewTracker contentViewTracker) {
        this.contentEventIndexer = contentEventIndexer;
        this.contentUpdateTracker = contentUpdateTracker;
        this.contentViewTracker = contentViewTracker;
    }

    public boolean isNoSpaceIndexed() {
        return this.contentEventIndexer.isNoSpaceIndexed();
    }

    public boolean isIndexed(Space space) {
        return this.contentEventIndexer.isIndexed(space);
    }

    public Map<Page, ContentUpdate> findPageUpdateEvents(Set<Page> pages) {
        return this.contentUpdateTracker.findLastEventsByPages(pages);
    }

    public Map<Page, ContentView> findPageViewEvents(Set<Page> pages) {
        return this.contentViewTracker.findLastEventsByPages(pages);
    }

    public Map<Page, ContentUpdate> findPageUpdateEventsOlderThan(Set<Page> pages, long minimumAge) {
        return this.contentUpdateTracker.findLastEventsByPages(pages, minimumAge);
    }

    public Map<Page, ContentView> findPageViewEventsOlderThan(Set<Page> pages, long minimumAge) {
        return this.contentViewTracker.findLastEventsByPages(pages, minimumAge);
    }
}

