/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model.base;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.midori.confluence.plugin.archiving.model.Anonymizable;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public abstract class ContentEvent
implements Anonymizable<ContentEvent> {
    protected static final String SERIALIZATION_DELIMITER = "|+*+|";
    protected int id;
    protected long pageId;
    protected String originatorName;
    protected Date date;

    protected ContentEvent() {
    }

    protected ContentEvent(String serialized) {
        String[] parts = StringUtils.split((String)serialized, (String)SERIALIZATION_DELIMITER);
        this.id = Integer.parseInt(parts[0]);
        this.pageId = Long.parseLong(parts[1]);
        this.date = new Date(Long.parseLong(parts[2]));
        this.originatorName = parts[3];
    }

    public int getId() {
        return this.id;
    }

    public long getPageId() {
        return this.pageId;
    }

    public String getOriginatorName() {
        return this.originatorName;
    }

    public Date getDate() {
        return this.date;
    }

    public String serialize() {
        String serialized = Joiner.on((String)SERIALIZATION_DELIMITER).join((Object)this.id, (Object)this.pageId, new Object[]{this.date.getTime(), this.originatorName});
        return serialized;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.pageId, this.originatorName, this.date});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContentEvent other = (ContentEvent)obj;
        return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal((Object)this.pageId, (Object)other.pageId) && Objects.equal((Object)this.originatorName, (Object)other.originatorName) && Objects.equal((Object)this.date, (Object)other.date);
    }

    public String toString() {
        return String.format("Page#%d %s on %s", this.pageId, this.originatorName, this.date);
    }
}

