/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.job;

import com.atlassian.fugue.Option;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleStatusHelper;
import com.midori.confluence.plugin.archiving.service.support.PluginHelper;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskManager;
import com.midori.confluence.plugin.archiving.service.task.base.AbstractArchivingLongRunningTask;
import com.midori.confluence.plugin.archiving.service.task.base.ArchivingLongRunningTask;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractArchivingJob
implements JobRunner {
    private static Logger log = LoggerFactory.getLogger(AbstractArchivingJob.class);
    private ContentLifecycleStatusHelper contentLifecycleStatusHelper;
    protected ContentLifecycleLongRunningTaskManager contentLifecycleLongRunningTaskManager;
    private PluginHelper pluginHelper;

    public AbstractArchivingJob(ContentLifecycleStatusHelper contentLifecycleStatusHelper, ContentLifecycleLongRunningTaskManager contentLifecycleLongRunningTaskManager, PluginHelper pluginHelper) {
        this.contentLifecycleStatusHelper = contentLifecycleStatusHelper;
        this.contentLifecycleLongRunningTaskManager = contentLifecycleLongRunningTaskManager;
        this.pluginHelper = pluginHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final JobRunnerResponse runJob(@Nullable JobRunnerRequest jobRunnerRequest) {
        JobRunnerResponse jobRunnerResponse;
        if (!this.contentLifecycleStatusHelper.isDisposable()) {
            String message = "Better Content Archiving for Confluence is not licensed: follow the instructions written at https://www.midori-global.com/products/better-content-archiving-for-confluence/data-center/buy and contact info[at]midori-global.com";
            log.error("Better Content Archiving for Confluence is not licensed: follow the instructions written at https://www.midori-global.com/products/better-content-archiving-for-confluence/data-center/buy and contact info[at]midori-global.com");
            return JobRunnerResponse.aborted((String)"Better Content Archiving for Confluence is not licensed: follow the instructions written at https://www.midori-global.com/products/better-content-archiving-for-confluence/data-center/buy and contact info[at]midori-global.com");
        }
        this.getLogger().debug(String.format("%s job started (version %s)", this.getName(), this.pluginHelper.getPluginVersion()));
        long start = System.currentTimeMillis();
        try {
            this.doBusinessLogic();
            jobRunnerResponse = JobRunnerResponse.success();
        }
        catch (Throwable throwable) {
            long durationInMilliSeconds = System.currentTimeMillis() - start;
            this.getLogger().debug(String.format("%s job completed in %d ms (%d s)", this.getName(), durationInMilliSeconds, durationInMilliSeconds / 1000L));
            throw throwable;
        }
        long durationInMilliSeconds = System.currentTimeMillis() - start;
        this.getLogger().debug(String.format("%s job completed in %d ms (%d s)", this.getName(), durationInMilliSeconds, durationInMilliSeconds / 1000L));
        return jobRunnerResponse;
    }

    protected abstract String getName();

    protected abstract Logger getLogger();

    protected abstract void doBusinessLogic();

    protected void startLongRunningTaskIfNotConflicting(AbstractArchivingLongRunningTask task) {
        Option<ArchivingLongRunningTask> currentlyRunningTask = this.contentLifecycleLongRunningTaskManager.getCurrentlyRunningTask();
        if (!currentlyRunningTask.isDefined()) {
            this.contentLifecycleLongRunningTaskManager.untrackFinishedTasks();
            this.contentLifecycleLongRunningTaskManager.startTask(task);
        } else {
            log.warn(String.format("Failed to start the %s task as %s is already running", task.getName(), ((ArchivingLongRunningTask)currentlyRunningTask.get()).getName()));
        }
    }
}

