/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web.rest.model;

public enum ContentStatusType {
    UP_TO_DATE("up-to-date", "Up-to-date", "This page is up-to-date"),
    NOT_VIEWED("not-viewed", "Not viewed", "This page is not viewed recently", "not viewed for %days%+ days"),
    EXPIRED_BY_LABEL("expired-by-label", "Expired", "This page expired %date%", "expiration date set by %user% ?(via an ancestor page)"),
    EXPIRED_BY_AGE("expired-by-age", "Expired", "This page expired %date%", "not updated for %days%+ days"),
    TO_BE_ARCHIVED_BY_LABEL("to-be-archived-by-label", "To be archived", "This page will be archived", "marked for archiving by %user% ?(via an ancestor page)"),
    TO_BE_ARCHIVED_BY_VIEW_AGE("to-be-archived-by-view-age", "To be archived", "This page will be archived", "not viewed for %days%+ days"),
    TO_BE_ARCHIVED_BY_AGE("to-be-archived-by-age", "To be archived", "This page will be archived", "not updated for %days%+ days"),
    TO_BE_ARCHIVED_BY_VIEW_AGE_AND_AGE("to-be-archived-by-view-age-and-age", "To be archived", "This page will be archived", "not updated for %days%+ and not viewed for %days2%+ days"),
    EXCLUDED("excluded", "Excluded", "This page is excluded from lifecycle checks", "by %user% ?(via an ancestor page)"),
    UNKNOWN_LAST_VIEW_UNAVAILABLE("unknown-last-view-unavailable", "Unknown", "Page status cannot be determined", "last view time is not known yet (try again later)"),
    UNKNOWN_LAST_UPDATE_UNAVAILABLE("unknown-last-update-unavailable", "Unknown", "Page status cannot be determined", "last update time is not known yet (try again later)");

    private String code;
    private String summary;
    private String description;
    private String subDescription;

    private ContentStatusType(String code, String summary, String description) {
        this.code = code;
        this.summary = summary;
        this.description = description;
    }

    private ContentStatusType(String code, String summary, String description, String subDescription) {
        this(code, summary, description);
        this.subDescription = subDescription;
    }

    public static ContentStatusType fromCode(String code) {
        for (ContentStatusType type : ContentStatusType.values()) {
            if (!type.getCode().equals(code.toLowerCase())) continue;
            return type;
        }
        throw new IllegalArgumentException(String.format("Unknown content status code <%s>", code));
    }

    public String getCode() {
        return this.code;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSubDescription() {
        return this.subDescription;
    }

    public String toString() {
        return "ContentStatusType{code='" + this.code + '\'' + '}';
    }
}

