/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web;

import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.fugue.Option;
import com.atlassian.user.User;
import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingConfigurationManager;
import com.midori.confluence.plugin.archiving.service.task.ContentArchivingLongRunningTask;
import com.midori.confluence.plugin.archiving.web.base.AbstractLongRunningArchivingTaskLauncherAction;

public class StartArchivingAction
extends AbstractLongRunningArchivingTaskLauncherAction<ContentArchivingLongRunningTask> {
    private ContentArchivingConfigurationManager contentArchivingConfigurationManager;
    private ContentArchivingConfiguration configuration;

    public void setContentArchivingConfigurationManager(ContentArchivingConfigurationManager contentArchivingConfigurationManager) {
        this.contentArchivingConfigurationManager = contentArchivingConfigurationManager;
    }

    public ContentArchivingConfiguration getConfiguration() {
        return this.configuration;
    }

    public String view() {
        if (!this.isGlobal()) {
            this.configuration = this.contentArchivingConfigurationManager.findResolvedConfiguration(this.getKey());
        }
        return "success";
    }

    @Override
    public String execute() {
        if (!this.isGlobal() && !this.isDangerousSpaceScopedActionPermitted()) {
            return "precondition-error";
        }
        return super.execute();
    }

    @Override
    protected ContentArchivingLongRunningTask createTask() {
        return this.isGlobal() ? this.contentLifecycleLongRunningTaskManager.createGlobalContentArchivingLongRunningTask() : this.contentLifecycleLongRunningTaskManager.createSpaceScopedContentArchivingLongRunningTask(this.space);
    }

    @Override
    protected Option<String> getLaunchPreconditionErrors() {
        Option<String> errors = super.getLaunchPreconditionErrors();
        if (errors.isDefined()) {
            return errors;
        }
        if (this.isGlobal()) {
            return Option.none();
        }
        User user = this.getRemoteUser();
        this.reloadArchiveSpace();
        if (this.archiveSpace == null) {
            boolean canCreateSpaces = this.permissionManager.hasCreatePermission(user, PermissionManager.TARGET_APPLICATION, Space.class);
            if (!canCreateSpaces) {
                return Option.some((Object)"The archive space does not exist yet, and you don't have the permission to create that.");
            }
        } else {
            boolean canAdministerArchiveSpace = this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)this.archiveSpace);
            if (!canAdministerArchiveSpace) {
                return Option.some((Object)"You do not have the permission to administer the archive space.");
            }
        }
        return Option.none();
    }
}

