/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web;

import com.atlassian.confluence.compat.struts2.servletactioncontext.ServletActionContextCompatManager;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.util.longrunning.LongRunningTaskId;
import com.atlassian.confluence.util.longrunning.LongRunningTaskManager;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.core.task.longrunning.LongRunningTask;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.midori.confluence.plugin.archiving.service.task.ContentLifecycleLongRunningTaskManager;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.springframework.util.ReflectionUtils;

public class LongRunningTaskMonitorAction
extends AbstractSpaceAction {
    private ContentLifecycleLongRunningTaskManager contentLifecycleLongRunningTaskManager;
    private LongRunningTaskManager longRunningTaskManager;
    private ServletActionContextCompatManager servletActionContextCompatManager;
    private LongRunningTask task;
    private String taskId;
    private String archivingContext;

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    public String execute() {
        this.task = this.contentLifecycleLongRunningTaskManager.getTask(this.taskId);
        if (this.task == null) {
            this.taskId = null;
            this.addActionError(this.getText("error.no.task"));
            return "notaskfound";
        }
        return "input";
    }

    @HtmlSafe
    public String getTaskName() {
        return this.task.getName();
    }

    @HtmlSafe
    public String getCurrentStatus() {
        return this.task.getCurrentStatus();
    }

    public LongRunningTask getTask() {
        return this.task;
    }

    public String getPrettyElapsedTime() {
        return this.getTask().getPrettyElapsedTime();
    }

    public String getPrettyTimeRemaining() {
        return this.getTask().getPrettyTimeRemaining();
    }

    @PermittedMethods(value={HttpMethod.GET})
    public String viewTaskStatus() {
        if (StringUtils.isNotBlank((CharSequence)this.taskId)) {
            try {
                Method startIfQueuedMethod = ReflectionUtils.findMethod(this.longRunningTaskManager.getClass(), (String)"startIfQueued", (Class[])new Class[]{LongRunningTaskId.class});
                startIfQueuedMethod.invoke((Object)this.longRunningTaskManager, LongRunningTaskId.valueOf((String)this.taskId));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        this.task = this.contentLifecycleLongRunningTaskManager.getTask(this.taskId);
        this.servletActionContextCompatManager.getResponse().setContentType("text/xml");
        return "success";
    }

    public String getTaskId() {
        return this.taskId;
    }

    @StrutsParameter
    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public String getArchivingContext() {
        return this.archivingContext;
    }

    @StrutsParameter
    public void setArchivingContext(String archivingContext) {
        this.archivingContext = archivingContext;
    }

    public void setContentLifecycleLongRunningTaskManager(ContentLifecycleLongRunningTaskManager contentLifecycleLongRunningTaskManager) {
        this.contentLifecycleLongRunningTaskManager = contentLifecycleLongRunningTaskManager;
    }

    public void setLongRunningTaskManager(LongRunningTaskManager longRunningTaskManager) {
        this.longRunningTaskManager = longRunningTaskManager;
    }

    public void setServletActionContextCompatManager(ServletActionContextCompatManager servletActionContextCompatManager) {
        this.servletActionContextCompatManager = servletActionContextCompatManager;
    }

    public boolean isPermitted() {
        return true;
    }
}

