/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web;

import com.atlassian.confluence.spaces.Space;
import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingConfigurationManager;
import com.midori.confluence.plugin.archiving.web.base.AbstractArchivingAction;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class ApplyGlobalConfigurationAction
extends AbstractArchivingAction {
    public static final String CUSTOM_CONFIGURATION_INDICATOR_NAME = "";
    private ContentArchivingConfigurationManager contentArchivingConfigurationManager;
    private int id;
    private List<String> selectedSpaceKeys;
    private ContentArchivingConfiguration contentArchivingConfiguration;
    private Map<Space, String> spaceToConfigurationNameMapping;

    public void setContentArchivingConfigurationManager(ContentArchivingConfigurationManager contentArchivingConfigurationManager) {
        this.contentArchivingConfigurationManager = contentArchivingConfigurationManager;
    }

    @StrutsParameter
    public void setId(int id) {
        this.id = id;
    }

    @StrutsParameter
    public void setSelectedSpaceKeys(List<String> selectedSpaceKeys) {
        this.selectedSpaceKeys = selectedSpaceKeys;
    }

    public int getId() {
        return this.id;
    }

    public ContentArchivingConfiguration getContentArchivingConfiguration() {
        return this.contentArchivingConfiguration;
    }

    public Map<Space, String> getSpaceToConfigurationNameMapping() {
        return this.spaceToConfigurationNameMapping;
    }

    public String view() {
        this.contentArchivingConfiguration = this.contentArchivingConfigurationManager.findGlobalConfiguration(this.id);
        this.spaceToConfigurationNameMapping = this.buildSpaceToConfigurationNameMapping();
        return "input";
    }

    public String save() {
        if (this.selectedSpaceKeys != null) {
            this.contentArchivingConfigurationManager.applyGlobalConfigurationToSpaces(this.id, this.selectedSpaceKeys);
        }
        return "success";
    }

    public static boolean isCustomConfiguration(String configurationName) {
        return configurationName.equals(CUSTOM_CONFIGURATION_INDICATOR_NAME);
    }

    private Map<Space, String> buildSpaceToConfigurationNameMapping() {
        LinkedHashMap<Space, String> spaceToConfigurationNameMapping = new LinkedHashMap<Space, String>();
        HashMap<String, Space> keyToSpaceMapping = new HashMap<String, Space>();
        List<Space> spaces = this.spaceHelper.findNonBlacklistedGlobalFreshSpaces();
        for (Space space : spaces) {
            keyToSpaceMapping.put(space.getKey(), space);
            spaceToConfigurationNameMapping.put(space, CUSTOM_CONFIGURATION_INDICATOR_NAME);
        }
        Map archivingConfigurations = ModelUtils.getIdentityMap(this.contentArchivingConfigurationManager.findGlobalConfigurations());
        Map<Integer, Set<String>> configurationToSpaceKeyMapping = this.contentArchivingConfigurationManager.getGlobalConfigurationToSpaceMapping();
        for (Map.Entry<Integer, Set<String>> entry : configurationToSpaceKeyMapping.entrySet()) {
            Integer configurationId = entry.getKey();
            Set<String> spaceKeys = entry.getValue();
            ContentArchivingConfiguration configuration = archivingConfigurations.get(configurationId);
            for (String spaceKey : spaceKeys) {
                Space space = (Space)keyToSpaceMapping.get(spaceKey);
                if (space == null) continue;
                spaceToConfigurationNameMapping.put(space, configuration.getName());
            }
        }
        return spaceToConfigurationNameMapping;
    }
}

