/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.tool;

import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.model.ContentUpdate;
import com.midori.confluence.plugin.archiving.model.ContentView;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingConfigurationManager;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightPage;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightSpace;
import com.midori.confluence.plugin.archiving.util.limited.LimitedMap;
import java.util.Map;

public class PageStatsTool {
    private ContentArchivingConfigurationManager contentArchivingConfigurationManager;
    private final long now = System.currentTimeMillis();

    public PageStatsTool(ContentArchivingConfigurationManager contentArchivingConfigurationManager) {
        this.contentArchivingConfigurationManager = contentArchivingConfigurationManager;
    }

    public long getLastViewedPageAgeInDays(LightSpace space, LimitedMap<LightSpace, LimitedMap<LightPage, ContentView>> spacesToNotViewedPages) {
        long maxLastViewTime = Long.MIN_VALUE;
        for (ContentView lastView : spacesToNotViewedPages.get(space).values()) {
            long lastViewTime = lastView.getViewDate().getTime();
            if (lastViewTime <= maxLastViewTime) continue;
            maxLastViewTime = lastViewTime;
        }
        return this.daysSince(maxLastViewTime);
    }

    public long getLastUpdatedPageAgeInDays(LightSpace space, LimitedMap<LightSpace, LimitedMap<LightPage, ContentUpdate>> spacesToExpiredPages) {
        long maxLastUpdateTime = Long.MIN_VALUE;
        for (ContentUpdate lastUpdate : spacesToExpiredPages.get(space).values()) {
            long lastUpdateTime = lastUpdate.getUpdateDate().getTime();
            if (lastUpdateTime <= maxLastUpdateTime) continue;
            maxLastUpdateTime = lastUpdateTime;
        }
        return this.daysSince(maxLastUpdateTime);
    }

    public long getFirstPageAutoArchivingInDays(LightSpace space, Map<LightSpace, Map<LightPage, ContentUpdate>> spacesToExpiredPages) {
        ContentArchivingConfiguration config = this.getArchivingConfiguration(space);
        if (!config.isPageArchivingByAgeEnabled()) {
            return -1L;
        }
        ContentUpdate minNonExplicitlyExpiredLastUpdate = this.getMinNonExplicitlyExpiredLastUpdate(space, spacesToExpiredPages);
        if (minNonExplicitlyExpiredLastUpdate == null) {
            return -2L;
        }
        long firstAutoArchivingInDays = 1L + (minNonExplicitlyExpiredLastUpdate.getUpdateDate().getTime() + config.getPageArchivingAge() * 86400000L - this.now) / 86400000L;
        return firstAutoArchivingInDays;
    }

    public ContentArchivingConfiguration getArchivingConfiguration(LightSpace space) {
        return this.contentArchivingConfigurationManager.findResolvedConfiguration(space.getKey());
    }

    protected ContentUpdate getMinNonExplicitlyExpiredLastUpdate(LightSpace space, Map<LightSpace, Map<LightPage, ContentUpdate>> spacesToExpiredPages) {
        ContentUpdate minNonExplicitlyExpiredLastUpdate = null;
        for (ContentUpdate lastUpdate : spacesToExpiredPages.get(space).values()) {
            if (lastUpdate.isExplicitlyExpired() || minNonExplicitlyExpiredLastUpdate != null && lastUpdate.getUpdateDate().getTime() >= minNonExplicitlyExpiredLastUpdate.getUpdateDate().getTime()) continue;
            minNonExplicitlyExpiredLastUpdate = lastUpdate;
        }
        return minNonExplicitlyExpiredLastUpdate;
    }

    private long daysSince(long time) {
        return (this.now - time) / 86400000L;
    }
}

