/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.spaces.Space;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.midori.confluence.plugin.archiving.model.ContentQualityStats;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.persistence.ContentQualityStatsManager;
import com.midori.confluence.plugin.archiving.tool.ContentQualityStatsTool;
import com.midori.confluence.plugin.archiving.util.SpaceByNameComparator;
import com.midori.confluence.plugin.archiving.web.base.AbstractNonBlacklistedArchivingAction;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewContentQualityStatsAction
extends AbstractNonBlacklistedArchivingAction {
    private static Logger log = LoggerFactory.getLogger(ViewContentQualityStatsAction.class);
    private ContentQualityStatsManager contentQualityStatsManager;
    private ContentQualityStatsTool contentQualityStatsTool;

    public void setContentQualityStatsManager(ContentQualityStatsManager contentQualityStatsManager) {
        this.contentQualityStatsManager = contentQualityStatsManager;
    }

    public ContentQualityStatsTool getContentQualityStatsTool() {
        return this.contentQualityStatsTool;
    }

    public String execute() {
        this.contentQualityStatsTool = this.isGlobal() ? this.buildGlobalContentQualityStatsTool() : this.buildSpaceContentQualityStatsTool();
        return "success";
    }

    private ContentQualityStatsTool buildGlobalContentQualityStatsTool() {
        List<Space> allSpaces = this.spaceHelper.findNonBlacklistedGlobalFreshSpaces();
        Set<Pair<Space, List<Labelling>>> spaceLabellings = this.spaceHelper.findSpacesWithTeamLabellings();
        Multimap<Label, Space> spacesBySpaceCategories = ViewContentQualityStatsAction.categorizeSpacesBySpaceLabels(allSpaces, spaceLabellings);
        Map<String, ContentQualityStats> statsBySpaces = this.contentQualityStatsManager.getContentQualityStatsBySpaces(ModelUtils.getSpaceKeys(spacesBySpaceCategories.values()));
        return new ContentQualityStatsTool(spacesBySpaceCategories.asMap(), statsBySpaces);
    }

    private static Multimap<Label, Space> categorizeSpacesBySpaceLabels(List<Space> spaces, Set<Pair<Space, List<Labelling>>> spaceLabellings) {
        SpaceByNameComparator spaceByNameComparator = new SpaceByNameComparator();
        TreeSet<Space> nonCategorizedSpaces = new TreeSet<Space>(spaceByNameComparator);
        nonCategorizedSpaces.addAll(spaces);
        TreeMultimap spaceCategoriesToSpaces = TreeMultimap.create((Comparator)Ordering.natural(), (Comparator)spaceByNameComparator);
        spaceLabellings.stream().filter(spaceLabellingsPair -> spaces.contains(spaceLabellingsPair.getKey())).flatMap(spaceLabellingsPair -> {
            Space space = (Space)spaceLabellingsPair.getKey();
            return ((List)spaceLabellingsPair.getValue()).stream().map(Labelling::getLabel).filter(label -> !label.getName().equals("noarchive")).map(label -> new ImmutablePair((Object)space, label));
        }).forEach(arg_0 -> ViewContentQualityStatsAction.lambda$categorizeSpacesBySpaceLabels$4((Multimap)spaceCategoriesToSpaces, nonCategorizedSpaces, arg_0));
        spaceCategoriesToSpaces.putAll((Object)new Label("<uncategorised>"), nonCategorizedSpaces);
        log.debug(String.format("%d spaces categorized into %d categories", spaces.size(), spaceCategoriesToSpaces.keySet().size()));
        return spaceCategoriesToSpaces;
    }

    private ContentQualityStatsTool buildSpaceContentQualityStatsTool() {
        return new ContentQualityStatsTool(null, Collections.singletonMap(this.space.getKey(), this.contentQualityStatsManager.getContentQualityStatsBySpace(this.space.getKey())));
    }

    private static /* synthetic */ void lambda$categorizeSpacesBySpaceLabels$4(Multimap spaceCategoriesToSpaces, Set nonCategorizedSpaces, ImmutablePair spaceLabelPair) {
        Space space = (Space)spaceLabelPair.getKey();
        Label label = (Label)spaceLabelPair.getValue();
        spaceCategoriesToSpaces.put((Object)label, (Object)space);
        nonCategorizedSpaces.remove(space);
    }
}

