/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.task.progress;

import com.atlassian.core.util.ProgressMeter;
import com.midori.confluence.plugin.archiving.service.task.progress.ProgressTracker;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartProgressMeter
extends ProgressMeter
implements ProgressTracker {
    private static final Logger log = LoggerFactory.getLogger(SmartProgressMeter.class);
    private String inProgressMessage;
    private final String completedMessage;
    private boolean completed = false;

    public SmartProgressMeter() {
        this("", "");
    }

    public SmartProgressMeter(String inProgressMessage, String completedMessage) {
        this.inProgressMessage = inProgressMessage;
        this.completedMessage = completedMessage;
        this.setPercentage(0);
    }

    @JsonIgnore
    public boolean isFailed() {
        return !this.isCompletedSuccessfully();
    }

    public String getInProgressMessage() {
        return this.inProgressMessage;
    }

    @Override
    public void setInProgressMessage(String inProgressMessage) {
        this.inProgressMessage = inProgressMessage;
    }

    public String getCompletedMessage() {
        return this.completedMessage;
    }

    @Override
    public void setPercentage(int count, int total) {
        log.trace(String.format("setPercentage(%d, %d)", count, total));
        super.setPercentage(count, total);
    }

    @Override
    public synchronized void setPercentage(int percentageComplete) {
        log.trace(String.format("setPercentage(%d)", percentageComplete));
        if (this.getTotal() > 0) {
            boolean readyButNotMarkedCompleted = !this.completed && percentageComplete >= 100;
            super.setPercentage(readyButNotMarkedCompleted ? 99 : percentageComplete);
            if (0 < this.getPercentageComplete() && this.getPercentageComplete() < 100) {
                if (StringUtils.isNotBlank((CharSequence)this.inProgressMessage)) {
                    this.setStatus(String.format(this.inProgressMessage, super.getCurrentCount(), super.getTotal()));
                }
            } else if (this.getPercentageComplete() >= 100) {
                this.setStatus(this.completedMessage);
            }
        } else {
            super.setPercentage(this.completed ? 100 : 0);
        }
    }

    @Override
    public void incrementCurrentCount() {
        this.setCurrentCount(this.getCurrentCount() + 1);
    }

    @Override
    public void markCompleted() {
        this.completed = true;
        this.setPercentage(100);
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public String toString() {
        return "SmartProgressMeter{percentageComplete=" + this.getPercentageComplete() + ", currentCount=" + this.getCurrentCount() + ", total=" + this.getTotal() + ", completed=" + this.completed + ", completedSuccessfully=" + this.isCompletedSuccessfully() + ", status='" + this.getStatus() + '\'' + "} " + super.toString();
    }
}

