/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support;

import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.exception.ArchivingActorException;
import com.midori.confluence.plugin.archiving.service.exception.ArchivingActorInvalidException;
import com.midori.confluence.plugin.archiving.service.exception.ArchivingActorNotFoundException;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingConfigurationManager;
import com.midori.confluence.plugin.archiving.service.support.ContentTraversalHelper;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightPage;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightSpace;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentLifecycleActorHelper {
    private static Logger log = LoggerFactory.getLogger(ContentLifecycleActorHelper.class);
    private static final String ANONYMOUS_NAME_I18N_KEY = "anonymous.name";
    private ContentArchivingConfigurationManager contentArchivingConfigurationManager;
    private ContentTraversalHelper contentTraversalHelper;
    private I18nResolver i18nResolver;
    private SpaceManager spaceManager;
    private SpacePermissionManager spacePermissionManager;
    private UserAccessor userAccessor;

    public ContentLifecycleActorHelper(ContentArchivingConfigurationManager contentArchivingConfigurationManager, ContentTraversalHelper contentTraversalHelper, I18nResolver i18nResolver, SpaceManager spaceManager, SpacePermissionManager spacePermissionManager, UserAccessor userAccessor) {
        this.contentArchivingConfigurationManager = contentArchivingConfigurationManager;
        this.contentTraversalHelper = contentTraversalHelper;
        this.i18nResolver = i18nResolver;
        this.spaceManager = spaceManager;
        this.spacePermissionManager = spacePermissionManager;
        this.userAccessor = userAccessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void withArchivingActor(Space space, Function<Space, Void> doWhileAuthenticated) throws ArchivingActorException {
        String string;
        ConfluenceUser previousUser = null;
        try {
            ContentArchivingConfiguration config = this.contentArchivingConfigurationManager.findResolvedConfiguration(space.getKey());
            String archivingActor = this.selectArchivingActor(config);
            previousUser = this.authenticateUser(archivingActor, String.format("for starting on <%s>", space.getKey()));
            doWhileAuthenticated.apply((Object)space);
            string = previousUser != null ? previousUser.getName() : null;
        }
        catch (Throwable throwable) {
            this.authenticateUser(previousUser != null ? previousUser.getName() : null, String.format("after completed on <%s>", space.getKey()));
            throw throwable;
        }
        this.authenticateUser(string, String.format("after completed on <%s>", space.getKey()));
    }

    private ConfluenceUser authenticateUser(String userName, String explanation) {
        log.trace(String.format("Authenticating as %s (%s)", userName != null ? "<" + userName + ">" : "NULL", explanation));
        ConfluenceUser user = null;
        if (userName != null && (user = this.findUserIfAvailable(userName)) == null) {
            throw new IllegalArgumentException(String.format("Actor <%s> is not available (deleted, disabled or permissions removed)", userName));
        }
        ConfluenceUser previousUser = AuthenticatedUserThreadLocal.get();
        AuthenticatedUserThreadLocal.set((ConfluenceUser)user);
        log.debug(String.format("Successfully authenticated as %s (%s), previously was %s", userName != null ? "<" + userName + ">" : "NULL", explanation, previousUser != null ? "<" + previousUser.getName() + ">" : "NULL"));
        return previousUser;
    }

    public String selectArchivingActor(ContentArchivingConfiguration configuration) throws ArchivingActorException {
        String userName = StringUtils.trimToNull((String)configuration.getPageArchivingActor());
        Set<String> archivingActorCandidates = this.findArchivingActorCandidateNames();
        if (StringUtils.isBlank((String)userName)) {
            if (!archivingActorCandidates.isEmpty()) {
                userName = ModelUtils.firstElement(archivingActorCandidates);
            } else {
                throw new ArchivingActorNotFoundException(userName);
            }
        }
        if (!archivingActorCandidates.contains(userName)) {
            throw new ArchivingActorInvalidException(userName);
        }
        return userName;
    }

    public Set<ConfluenceUser> findArchivingActorCandidates() {
        LinkedHashSet<ConfluenceUser> actorCandidates = new LinkedHashSet<ConfluenceUser>();
        Group confluenceAdminsGroup = this.userAccessor.getGroup("confluence-administrators");
        List confluenceAdminNames = confluenceAdminsGroup != null ? this.userAccessor.getMemberNamesAsList(confluenceAdminsGroup) : Collections.emptyList();
        for (String confluenceAdminName : confluenceAdminNames) {
            ConfluenceUser confluenceAdmin = this.findUserIfAvailable(confluenceAdminName);
            if (confluenceAdmin == null) continue;
            actorCandidates.add(confluenceAdmin);
        }
        return actorCandidates;
    }

    public Set<String> findArchivingActorCandidateNames() {
        return new LinkedHashSet<String>(Collections2.transform(this.findArchivingActorCandidates(), (Function)new Function<ConfluenceUser, String>(){

            public String apply(ConfluenceUser confluenceUser) {
                return confluenceUser.getName();
            }
        }));
    }

    public Multimap<String, LightPage> findAuthorsByPages(Collection<LightPage> pages, Function<LightPage, LightPage> mapper) {
        ArrayListMultimap authors = ArrayListMultimap.create();
        for (LightPage page : pages) {
            LightPage mappedPage = (LightPage)mapper.apply((Object)page);
            if (!StringUtils.isNotBlank((String)mappedPage.getCreatorName())) continue;
            authors.put((Object)mappedPage.getCreatorName(), (Object)page);
        }
        return authors;
    }

    public Multimap<String, LightPage> findLastModifiersByPages(Collection<LightPage> pages, Function<LightPage, LightPage> mapper) {
        ArrayListMultimap lastModifiers = ArrayListMultimap.create();
        for (LightPage page : pages) {
            LightPage mappedPage = (LightPage)mapper.apply((Object)page);
            if (!StringUtils.isNotBlank((String)mappedPage.getLastModifierName())) continue;
            lastModifiers.put((Object)mappedPage.getLastModifierName(), (Object)page);
        }
        return lastModifiers;
    }

    public Multimap<String, LightPage> findOwnersByPages(Collection<LightPage> pages) {
        ArrayListMultimap owners = ArrayListMultimap.create();
        Space space = this.spaceManager.getSpace(pages.iterator().next().getSpaceKey());
        HashMultimap<Long, String> ownedPages = this.contentTraversalHelper.findPagesLabelledWithUserName(space, "owned-single-by-", "owned-by-", "owned-by-user-type labels");
        if (!ownedPages.isEmpty()) {
            for (LightPage page : pages) {
                if (!ownedPages.containsKey((Object)page.getId())) continue;
                for (String owner : ownedPages.get((Object)page.getId())) {
                    owners.put((Object)owner, (Object)page);
                }
            }
        }
        return owners;
    }

    public Multimap<String, LightPage> findSpaceAdminsByPages(Collection<LightPage> pages, LightSpace space) {
        ArrayListMultimap spaceAdmins = ArrayListMultimap.create();
        Set<String> spaceAdminNames = this.findSpaceAdminNames(space.getKey());
        for (String spaceAdmin : spaceAdminNames) {
            for (LightPage page : pages) {
                spaceAdmins.put((Object)spaceAdmin, (Object)page);
            }
        }
        return spaceAdmins;
    }

    public Multimap<String, LightPage> findSpaceCreatorsByPages(Collection<LightPage> pages, LightSpace space) {
        ArrayListMultimap spaceCreators = ArrayListMultimap.create();
        if (space.getCreatorName() != null && StringUtils.isNotBlank((String)space.getCreatorName())) {
            for (LightPage page : pages) {
                spaceCreators.put((Object)space.getCreatorName(), (Object)page);
            }
        }
        return spaceCreators;
    }

    public ConfluenceUser findUserIfAvailable(String userName) {
        if (StringUtils.isBlank((String)userName)) {
            return null;
        }
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        if (user == null) {
            log.trace(String.format("User <%s> not found", userName));
            return null;
        }
        if (this.userAccessor.isDeactivated((User)user)) {
            log.trace(String.format("User <%s> is disabled", userName));
            return null;
        }
        return user;
    }

    private Set<String> findSpaceAdminNames(String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        HashSet<String> spaceAdminNames = new HashSet<String>();
        Map spaceAdministrators = this.spacePermissionManager.getUsersForPermissionType("SETSPACEPERMISSIONS", space);
        for (String spaceAdminName : spaceAdministrators.keySet()) {
            if (!StringUtils.isNotBlank((String)spaceAdminName)) continue;
            spaceAdminNames.add(spaceAdminName);
        }
        Map spaceAdministratorGroups = this.spacePermissionManager.getGroupsForPermissionType("SETSPACEPERMISSIONS", space);
        for (String administratorGroupName : spaceAdministratorGroups.keySet()) {
            Group administratorGroup;
            if (!StringUtils.isNotBlank((String)administratorGroupName) || (administratorGroup = this.userAccessor.getGroup(administratorGroupName)) == null) continue;
            List members = this.userAccessor.getMemberNamesAsList(administratorGroup);
            for (String spaceAdminName : members) {
                if (!StringUtils.isNotBlank((String)spaceAdminName)) continue;
                spaceAdminNames.add(spaceAdminName);
            }
        }
        return spaceAdminNames;
    }

    public String getUserName(ConfluenceUser user) {
        return user != null ? user.getName() : this.i18nResolver.getText(ANONYMOUS_NAME_I18N_KEY);
    }

    public String getUserDisplayName(String userName) {
        if (userName == null) {
            return this.i18nResolver.getText(ANONYMOUS_NAME_I18N_KEY);
        }
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        return user != null ? user.getFullName() : userName;
    }
}

