/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model.util;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.midori.confluence.plugin.archiving.model.base.Identifiable;
import com.midori.confluence.plugin.archiving.util.limited.LimitedMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class ModelUtils {
    public static final String CURRENT_MODEL_VERSION = "3";
    public static final String MODEL_VERSION_KEY = "AO_1991C6_#";
    private static final String COMMA_SEPARATOR = ",";

    public static Page asPage(Object obj) {
        return obj instanceof Page ? (Page)obj : null;
    }

    public static Set<Long> getPageIds(Collection<Page> pages) {
        return ModelUtils.getPageIdentityMap(pages).keySet();
    }

    public static Set<String> getSpaceKeys(Collection<Space> spaces) {
        return ModelUtils.getSpaceKeyMap(spaces).keySet();
    }

    public static Map<Long, Page> getPageIdentityMap(Collection<Page> pages) {
        LinkedHashMap<Long, Page> pageIdentityMap = new LinkedHashMap<Long, Page>(pages.size());
        for (Page page : pages) {
            pageIdentityMap.put(page.getId(), page);
        }
        return pageIdentityMap;
    }

    public static Map<String, Space> getSpaceKeyMap(Collection<Space> spaces) {
        LinkedHashMap<String, Space> spaceKeyMap = new LinkedHashMap<String, Space>(spaces.size());
        for (Space space : spaces) {
            spaceKeyMap.put(space.getKey(), space);
        }
        return spaceKeyMap;
    }

    public static <T extends Number, I extends Identifiable<T>> Map<T, I> getIdentityMap(Collection<I> identifiables) {
        LinkedHashMap identityMap = new LinkedHashMap();
        for (Identifiable identifiable : identifiables) {
            identityMap.put(identifiable.getId(), identifiable);
        }
        return identityMap;
    }

    public static <T> T firstElement(Collection<T> collection) {
        return collection.iterator().next();
    }

    public static <T> void removeNullValues(Map<Page, T> map) {
        Iterator<Map.Entry<Page, T>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Page, T> entry = iterator.next();
            if (entry.getValue() != null) continue;
            iterator.remove();
        }
    }

    public static <K1, K2, V2> int getMapValuedMapSize(Map<K1, Map<K2, V2>> mapValuedMap) {
        int totalSize = 0;
        for (Map<K2, V2> value : mapValuedMap.values()) {
            totalSize += value.size();
        }
        return totalSize;
    }

    public static <K1, K2, V2> int getLimitedMapValuedLimitedMapSize(LimitedMap<K1, LimitedMap<K2, V2>> limitedMapValuedLimitedMap) {
        int totalSize = 0;
        for (LimitedMap<K2, V2> value : limitedMapValuedLimitedMap.values()) {
            totalSize += value.size();
        }
        return totalSize;
    }

    public static <K, V, W> void retainOnlyIntersectingKeys(Map<K, V> collection1, Map<K, W> collection2) {
        HashSet<K> intersection = new HashSet<K>(collection1.keySet());
        intersection.retainAll(collection2.keySet());
        collection1.keySet().retainAll(intersection);
        collection2.keySet().retainAll(intersection);
    }

    public static <T> boolean equalCollections(Collection<T> c1, Collection<T> c2, Comparator<T> comparator) {
        if (c1.size() != c2.size()) {
            return false;
        }
        if (c1.isEmpty()) {
            return true;
        }
        Iterator<T> it1 = c1.iterator();
        Iterator<T> it2 = c2.iterator();
        do {
            T o1 = it1.next();
            T o2 = it2.next();
            if (!(o1 == null && o2 != null || o1 != null && o2 == null) && (o1 == null || o2 == null || comparator.compare(o1, o2) == 0)) continue;
            return false;
        } while (it1.hasNext());
        return true;
    }

    public static <T> String serializeObjectSet(Set<T> objects) {
        return Joiner.on((String)COMMA_SEPARATOR).skipNulls().join(objects);
    }

    public static Set<Long> deserializeLongSet(String longsAsCsv) {
        Iterable longAsStrings = Splitter.on((String)COMMA_SEPARATOR).omitEmptyStrings().split((CharSequence)StringUtils.defaultString((String)longsAsCsv));
        LinkedHashSet<Long> longs = new LinkedHashSet<Long>();
        for (String longAsString : longAsStrings) {
            try {
                longs.add(Long.parseLong(longAsString));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return longs;
    }

    public static int safeCompareStrings(String s1, String s2) {
        String sd1 = StringUtils.defaultString((String)s1, (String)"");
        String sd2 = StringUtils.defaultString((String)s2, (String)"");
        return sd1.compareTo(sd2);
    }

    public static int compareLongs(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }
}

