/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.midori.confluence.plugin.archiving.model.base.AbstractContentLifecycleStats;
import com.midori.confluence.plugin.archiving.model.base.SpaceAndPageCountingStats;

public class ContentViewStats
extends AbstractContentLifecycleStats
implements SpaceAndPageCountingStats {
    private Multiset<String> spaceKeyToNotViewedPageCount = HashMultiset.create();

    public void addNotViewedPagesForSpace(String spaceKey, int notViewedPages) {
        this.spaceKeyToNotViewedPageCount.add((Object)spaceKey, notViewedPages);
    }

    public int getNotViewedPagesBySpace(String spaceKey) {
        return this.spaceKeyToNotViewedPageCount.count((Object)spaceKey);
    }

    public int getNotViewedPages() {
        return this.spaceKeyToNotViewedPageCount.size();
    }

    @Override
    public int getSpaceCount() {
        return this.spaceKeyToNotViewedPageCount.elementSet().size();
    }

    @Override
    public int getPageCount() {
        return this.getNotViewedPages();
    }

    @Override
    public int getPageCountBySpace(String spaceKey) {
        return this.getNotViewedPagesBySpace(spaceKey);
    }
}

