/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model;

import com.midori.confluence.plugin.archiving.model.ContentUpdate;
import com.midori.confluence.plugin.archiving.model.ao.ContentViewEventAo;
import com.midori.confluence.plugin.archiving.model.base.ContentEvent;
import java.util.Date;

public class ContentView
extends ContentEvent {
    public static ContentView fromAo(ContentViewEventAo ao) {
        if (ao == null) {
            throw new IllegalArgumentException("ContentViewEventAo provided must not be null");
        }
        return new ContentView(ao.getID(), ao.getPageId(), ao.getViewerName(), ao.getViewDate());
    }

    public static ContentView newGeneric(String viewerName, Date viewDate) {
        return new ContentView(viewerName, viewDate);
    }

    public static ContentView copyFromContentUpdate(ContentUpdate update) {
        return new ContentView(update.getUpdaterName(), update.getUpdateDate());
    }

    public ContentView() {
    }

    @Override
    public ContentEvent anonymized() {
        return new ContentView(this.id, this.pageId, "undisclosed user", this.date);
    }

    private ContentView(int id, long pageId, String viewerName, Date viewDate) {
        this.id = id;
        this.pageId = pageId;
        this.originatorName = viewerName;
        this.date = viewDate;
    }

    private ContentView(String viewerName, Date viewDate) {
        this.originatorName = viewerName;
        this.date = viewDate;
    }

    public ContentView(String serialized) {
        super(serialized);
    }

    public String getViewerName() {
        return this.getOriginatorName();
    }

    public Date getViewDate() {
        return this.getDate();
    }
}

