;(function($) {
	$(document).ready(function($) {
		// waiting for DOM initialization is important: CSS must be already loaded to calculate correct height values

		var container = $("#pageArchiving").find("fieldset").first();

		var applyToOperatorGroups = function(logic) {
			return function() {
				// loop must iterate from inside to outside to get correct heights for outer elements.
				$($(".operatorGroup").get().reverse()).each(function() {
					logic.call(this, $(this));
				});
			}
		};

		var initBraces = applyToOperatorGroups(function(group) {
			var braceInner = $("<div>").addClass("braceInner").css("height", group.outerHeight());
			$("<div>").addClass("brace").html(braceInner).insertBefore(group);
		});

		var refreshHeights = applyToOperatorGroups(function(group) {
			group.siblings().find(".braceInner").css("height", group.outerHeight());
		});

		initBraces();

		var updateBraceState = function() {
			var isAndSet = function() {
				var selector = $("#pageArchivingOperatorAnd");
				return selector.val() == "pageArchivingOperatorAnd_and";
			};
			var areBothOperandsChecked = function() {
				return $("#pageArchivingByViewAgeEnabled, #pageArchivingByAgeEnabled").filter(":checked").length == 2;
			};
			container.toggleClass("bracesNeeded", isAndSet() && areBothOperandsChecked());
			refreshHeights();
			return true;
		};

		$("#pageArchivingByViewAgeEnabled, #pageArchivingByAgeEnabled, #pageArchivingOperatorAnd").change(updateBraceState);
		updateBraceState();
	});
})(AJS.$);
