/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.fugue.Option;
import com.midori.confluence.plugin.archiving.service.task.base.ArchivingLongRunningTask;
import com.midori.confluence.plugin.archiving.web.base.AbstractArchivingAction;
import com.midori.confluence.plugin.archiving.web.support.WebFrameworkCompatibilityHelper;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopLongRunningTasksAction
extends AbstractArchivingAction {
    private static final Logger log = LoggerFactory.getLogger(StopLongRunningTasksAction.class);
    private static final String CONTENT_QUALITY_SPACE = "content-quality-space";
    private static final String CONTENT_QUALITY_GLOBAL = "content-quality-global";

    public String execute() throws IOException {
        String referrer;
        Option<ArchivingLongRunningTask> task = this.contentLifecycleLongRunningTaskManager.getCurrentlyRunningTask();
        if (task.isDefined() && this.contentLifecyclePermissionHelper.canStopTask((ArchivingLongRunningTask)task.get())) {
            ConfluenceUser user = AuthenticatedUserThreadLocal.get();
            log.info(String.format("User \"%s\" is stopping all currently running tasks", user.getName()));
            this.contentLifecycleLongRunningTaskManager.stopAllTasks();
        }
        if (StringUtils.isNotBlank((CharSequence)(referrer = WebFrameworkCompatibilityHelper.getServletRequest().getHeader("referer")))) {
            WebFrameworkCompatibilityHelper.getServletResponse().sendRedirect(referrer);
            return "none";
        }
        return this.isGlobal() ? CONTENT_QUALITY_GLOBAL : CONTENT_QUALITY_SPACE;
    }
}

