/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web;

import com.midori.confluence.plugin.archiving.model.ContentArchivingConfiguration;
import com.midori.confluence.plugin.archiving.model.type.ContentArchivingStrategyType;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.persistence.ContentArchivingConfigurationManager;
import com.midori.confluence.plugin.archiving.service.support.ContentLifecycleActorHelper;
import com.midori.confluence.plugin.archiving.web.base.AbstractArchivingAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class ConfigureArchivingAction
extends AbstractArchivingAction {
    private ContentArchivingConfigurationManager contentArchivingConfigurationManager;
    private ContentLifecycleActorHelper contentLifecycleActorHelper;
    private Integer id;
    private ContentArchivingConfiguration resolvedConfiguration = null;
    private ContentArchivingConfiguration configuration = ContentArchivingConfiguration.createDefault();
    private Map<Integer, ContentArchivingConfiguration> globalConfigurations;

    public void setContentArchivingConfigurationManager(ContentArchivingConfigurationManager contentArchivingConfigurationManager) {
        this.contentArchivingConfigurationManager = contentArchivingConfigurationManager;
    }

    @Override
    public void setContentLifecycleActorHelper(ContentLifecycleActorHelper contentLifecycleActorHelper) {
        this.contentLifecycleActorHelper = contentLifecycleActorHelper;
    }

    public ContentArchivingConfiguration getResolvedConfiguration() {
        return this.resolvedConfiguration;
    }

    public ContentArchivingConfiguration getConfiguration() {
        return this.configuration;
    }

    public Map<Integer, ContentArchivingConfiguration> getGlobalConfigurations() {
        return this.globalConfigurations;
    }

    public List<ContentArchivingStrategyType> getArchivingStrategyTypes() {
        return Arrays.asList(ContentArchivingStrategyType.values());
    }

    public Set<String> getPageArchivingActorCandidates() {
        return this.contentLifecycleActorHelper.findArchivingActorCandidateNames();
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
        this.configuration.setId(id);
    }

    public void setGlobalConfigurationId(Integer globalConfigurationId) {
        this.configuration.setGlobalConfigurationId(globalConfigurationId);
    }

    public void setName(String name) {
        this.configuration.setName(StringUtils.trimToNull((String)name));
    }

    public void setBaseBehaviour(String behaviour) {
        this.configuration.setGlobalRunsEnabled(StringUtils.contains((String)behaviour, (String)"globalRunsEnabled"));
    }

    public void setPageViewTrackingBehaviour(String behaviour) {
        this.configuration.setPageViewTrackingByAgeEnabled(StringUtils.contains((String)behaviour, (String)"pageViewTrackingByAgeEnabled"));
        this.configuration.setNotifyAuthorOnPageView(StringUtils.contains((String)behaviour, (String)"notifyAuthorOnPageView"));
        this.configuration.setNotifyLastModifierOnPageView(StringUtils.contains((String)behaviour, (String)"notifyLastModifierOnPageView"));
        this.configuration.setNotifyOwnersOnPageView(StringUtils.contains((String)behaviour, (String)"notifyOwnersOnPageView"));
        this.configuration.setNotifySpaceAdminsOnPageView(StringUtils.contains((String)behaviour, (String)"notifySpaceAdminsOnPageView"));
        this.configuration.setNotifySpaceCreatorOnPageView(StringUtils.contains((String)behaviour, (String)"notifySpaceCreatorOnPageView"));
        this.configuration.setNotifySupervisorsOnPageView(StringUtils.contains((String)behaviour, (String)"notifySupervisorsOnPageView"));
    }

    public void setPageViewAlertAge(long pageViewAlertAge) {
        this.configuration.setPageViewAlertAge(pageViewAlertAge);
    }

    public void setSupervisorsOnPageView(String supervisorsOnPageView) {
        this.configuration.setSupervisorsOnPageView(ConfigureArchivingAction.sanitizeUserNamesCsv(supervisorsOnPageView));
    }

    public void setPageExpirationTrackingBehaviour(String behaviour) {
        this.configuration.setPageExpirationTrackingByAgeEnabled(StringUtils.contains((String)behaviour, (String)"pageExpirationTrackingByAgeEnabled"));
        this.configuration.setPageExpirationTrackingByLabelEnabled(StringUtils.contains((String)behaviour, (String)"pageExpirationTrackingByLabelEnabled"));
        this.configuration.setNotifyAuthorOnPageExpiration(StringUtils.contains((String)behaviour, (String)"notifyAuthorOnPageExpiration"));
        this.configuration.setNotifyLastModifierOnPageExpiration(StringUtils.contains((String)behaviour, (String)"notifyLastModifierOnPageExpiration"));
        this.configuration.setNotifyOwnersOnPageExpiration(StringUtils.contains((String)behaviour, (String)"notifyOwnersOnPageExpiration"));
        this.configuration.setNotifySpaceAdminsOnPageExpiration(StringUtils.contains((String)behaviour, (String)"notifySpaceAdminsOnPageExpiration"));
        this.configuration.setNotifySpaceCreatorOnPageExpiration(StringUtils.contains((String)behaviour, (String)"notifySpaceCreatorOnPageExpiration"));
        this.configuration.setNotifySupervisorsOnPageExpiration(StringUtils.contains((String)behaviour, (String)"notifySupervisorsOnPageExpiration"));
    }

    public void setPageExpirationAlertAge(long pageExpirationAlertAge) {
        this.configuration.setPageExpirationAlertAge(pageExpirationAlertAge);
    }

    public void setSupervisorsOnPageExpiration(String supervisorsOnPageExpiration) {
        this.configuration.setSupervisorsOnPageExpiration(ConfigureArchivingAction.sanitizeUserNamesCsv(supervisorsOnPageExpiration));
    }

    public void setPageArchivingBehaviour(String behaviour) {
        this.configuration.setPageArchivingByViewAgeEnabled(StringUtils.contains((String)behaviour, (String)"pageArchivingByViewAgeEnabled"));
        this.configuration.setPageArchivingOperatorAnd(StringUtils.contains((String)behaviour, (String)"pageArchivingOperatorAnd_and"));
        this.configuration.setPageArchivingByAgeEnabled(StringUtils.contains((String)behaviour, (String)"pageArchivingByAgeEnabled"));
        this.configuration.setPageArchivingByLabelEnabled(StringUtils.contains((String)behaviour, (String)"pageArchivingByLabelEnabled"));
        this.configuration.setNotifyAuthorOnPageArchiving(StringUtils.contains((String)behaviour, (String)"notifyAuthorOnPageArchiving"));
        this.configuration.setNotifyLastModifierOnPageArchiving(StringUtils.contains((String)behaviour, (String)"notifyLastModifierOnPageArchiving"));
        this.configuration.setNotifyOwnersOnPageArchiving(StringUtils.contains((String)behaviour, (String)"notifyOwnersOnPageArchiving"));
        this.configuration.setNotifySpaceAdminsOnPageArchiving(StringUtils.contains((String)behaviour, (String)"notifySpaceAdminsOnPageArchiving"));
        this.configuration.setNotifySpaceCreatorOnPageArchiving(StringUtils.contains((String)behaviour, (String)"notifySpaceCreatorOnPageArchiving"));
        this.configuration.setNotifySupervisorsOnPageArchiving(StringUtils.contains((String)behaviour, (String)"notifySupervisorsOnPageArchiving"));
        this.configuration.setArchiveSpaceHidden(StringUtils.contains((String)behaviour, (String)"archiveSpaceHidden"));
        this.configuration.setArchivingReasonRequired(StringUtils.contains((String)behaviour, (String)"archivingReasonRequired"));
    }

    public void setPageArchivingViewAge(long pageArchivingViewAge) {
        this.configuration.setPageArchivingViewAge(pageArchivingViewAge);
    }

    public void setPageArchivingAge(long pageArchivingAge) {
        this.configuration.setPageArchivingAge(pageArchivingAge);
    }

    public void setSupervisorsOnPageArchiving(String supervisorsOnPageArchiving) {
        this.configuration.setSupervisorsOnPageArchiving(ConfigureArchivingAction.sanitizeUserNamesCsv(supervisorsOnPageArchiving));
    }

    public void setArchivingStrategyType(String archivingStrategyType) {
        this.configuration.setArchivingStrategyType(ContentArchivingStrategyType.valueOf(archivingStrategyType));
    }

    public void setPageArchivingActor(String pageArchivingActor) {
        this.configuration.setPageArchivingActor(StringUtils.trimToNull((String)pageArchivingActor));
    }

    public String view() {
        this.resolvedConfiguration = this.contentArchivingConfigurationManager.findResolvedConfiguration(this.key);
        return "view";
    }

    public String update() {
        if (this.isGlobal()) {
            this.configuration = this.id != null ? this.contentArchivingConfigurationManager.findGlobalConfiguration(this.id) : ContentArchivingConfiguration.createDefault();
        } else if (this.isDangerousSpaceScopedActionPermitted()) {
            this.configuration = this.contentArchivingConfigurationManager.findSpaceScopedConfiguration(this.key);
        } else {
            return "error";
        }
        this.globalConfigurations = this.isGlobal() ? null : ModelUtils.getIdentityMap(this.contentArchivingConfigurationManager.findGlobalConfigurations());
        this.reloadArchiveSpace();
        return "input";
    }

    public String save() {
        if (this.isSessionExpired() || !this.isGlobal() && !this.isDangerousSpaceScopedActionPermitted()) {
            return "error";
        }
        if (!this.isGlobal()) {
            this.configuration.setSpaceKey(this.key);
        }
        this.contentArchivingConfigurationManager.saveConfiguration(this.configuration);
        this.contentArchivingConfigurationManager.purgeDeletedSpaceConfigurations();
        return "success";
    }

    private static String sanitizeUserNamesCsv(String userNamesCsv) {
        if (StringUtils.isBlank((String)userNamesCsv)) {
            return null;
        }
        List<String> userNames = Arrays.asList(userNamesCsv.split(","));
        TreeSet<String> trimmedUserNames = new TreeSet<String>();
        for (String userName : userNames) {
            String trimmedUserName = StringUtils.trimToNull((String)userName);
            if (trimmedUserName == null) continue;
            trimmedUserNames.add(trimmedUserName);
        }
        return StringUtils.join(trimmedUserNames, (String)",");
    }
}

