/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.task;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.midori.confluence.plugin.archiving.service.task.result.LongRunningTaskResult;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentLifecycleLongRunningTaskResultManager {
    private static final Logger log = LoggerFactory.getLogger(ContentLifecycleLongRunningTaskResultManager.class);
    private static final String CACHE_NAME = "Archiving Plugin: Long Running Task Results";
    private final Cache<String, LongRunningTaskResult> cache;

    public ContentLifecycleLongRunningTaskResultManager(CacheManager cacheManager) {
        this.cache = cacheManager.getCache(CACHE_NAME, null, new CacheSettingsBuilder().expireAfterAccess(24L, TimeUnit.HOURS).build());
    }

    public LongRunningTaskResult getResult(String taskId) {
        log.debug(String.format("Getting task result <%s> from cache", taskId));
        return (LongRunningTaskResult)this.cache.get((Object)taskId);
    }

    public void putResult(String taskId, LongRunningTaskResult result) {
        log.debug(String.format("Putting task result <%s> to cache: %s", taskId, result));
        this.cache.put((Object)taskId, (Object)result);
    }
}

