/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.strategy.impl;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.midori.confluence.plugin.archiving.model.PageArchiving;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.strategy.ContentArchivingExecutionContext;
import com.midori.confluence.plugin.archiving.service.strategy.ContentArchivingExecutionSpecification;
import com.midori.confluence.plugin.archiving.service.strategy.impl.AbstractReplicatingArchivingStrategy;
import com.midori.confluence.plugin.archiving.service.strategy.replication.PageReplicator;
import com.midori.confluence.plugin.archiving.service.strategy.replication.SpaceReplicator;
import com.midori.confluence.plugin.archiving.service.support.ContentTraversalHelper;
import com.midori.confluence.plugin.archiving.service.support.SpaceHelper;
import com.midori.confluence.plugin.archiving.service.task.progress.ProgressTracker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoveArchivingStrategy
extends AbstractReplicatingArchivingStrategy {
    private static Logger log = LoggerFactory.getLogger(MoveArchivingStrategy.class);
    private final Map<Page, Page> freshPagesToArchiveParents = new HashMap<Page, Page>();

    public MoveArchivingStrategy(SpaceManager spaceManager, PageManager pageManager, ContentTraversalHelper contentTraversalHelper, PageReplicator pageReplicator, SpaceReplicator spaceReplicator, SpaceHelper spaceHelper, ProgressTracker progressTracker) {
        super(spaceManager, pageManager, contentTraversalHelper, pageReplicator, spaceReplicator, spaceHelper, progressTracker);
    }

    @Override
    public boolean requiresSortedFreshPages(int pagesToArchiveCount) {
        return pagesToArchiveCount > 1;
    }

    @Override
    protected void beforePageReplication(ContentArchivingExecutionSpecification specification, ContentArchivingExecutionContext context) {
    }

    @Override
    protected void replicatePage(ContentArchivingExecutionContext context, Page freshPageToArchive, Map<Page, PageArchiving> freshPagesToArchive, Space archiveSpace) {
        Page archiveParent = this.freshPagesToArchiveParents.get(freshPageToArchive);
        if (!freshPageToArchive.isRootLevel() && archiveParent == null) {
            List<Page> freshPartialBranch = this.contentTraversalHelper.findPartialBranch(freshPageToArchive.getParent(), this.freshPagesToArchiveParents);
            archiveParent = this.replicateBranch(context, freshPageToArchive, freshPartialBranch, freshPagesToArchive, archiveSpace.getKey(), this.freshPagesToArchiveParents.get(freshPartialBranch.get(0)));
        }
        for (Page childPage : freshPageToArchive.getChildren()) {
            this.freshPagesToArchiveParents.put(childPage, freshPageToArchive);
        }
        this.pageReplicator.moveChildrenUp(freshPageToArchive);
        log.debug(String.format("Moving <%s> to archive (%d of %d)", freshPageToArchive.getTitle(), 1 + context.getFreshPagesArchived().size(), freshPagesToArchive.size()));
        boolean wasConflictingPageOverwritten = this.pageReplicator.moveToSpace(freshPageToArchive, archiveSpace, archiveParent);
        if (!wasConflictingPageOverwritten) {
            this.afterArchivePageCreated(context, freshPageToArchive, freshPageToArchive, freshPageToArchive, freshPagesToArchive);
        } else {
            this.afterArchivePageUpdated(context, freshPageToArchive, freshPageToArchive, freshPageToArchive, freshPagesToArchive);
        }
    }

    @Override
    protected void afterPageReplication(ContentArchivingExecutionSpecification specification, ContentArchivingExecutionContext context) {
        Map<Page, PageArchiving> archivePagesUpdated = context.getArchivePagesResulted();
        Set<Long> archivePageIdsUpdated = ModelUtils.getPageIds(archivePagesUpdated.keySet());
        archivePagesUpdated.clear();
        Set<Page> freshPagesArchived = context.getFreshPagesArchived();
        Set<Long> freshPageIdsArchived = ModelUtils.getPageIds(freshPagesArchived);
        freshPagesArchived.clear();
        for (Map.Entry<Page, PageArchiving> entry : specification.getFreshPagesToArchive().entrySet()) {
            Page page = entry.getValue().getFreshPage();
            if (archivePageIdsUpdated.contains(page.getId())) {
                archivePagesUpdated.put(page, entry.getValue());
            }
            if (!freshPageIdsArchived.contains(page.getId())) continue;
            freshPagesArchived.add(page);
        }
    }
}

