/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.model;

import com.midori.confluence.plugin.archiving.model.ao.ContentArchivingEventAo;
import com.midori.confluence.plugin.archiving.model.type.ArchivingEventType;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

public class ContentArchivingEvent {
    private int id;
    private Date date;
    private String spaceKey;
    private ArchivingEventType eventType;
    private String user;
    private Set<Long> pageIds;
    private int remainingPageCount;

    public static ContentArchivingEvent fromAo(ContentArchivingEventAo ao) {
        if (ao == null) {
            throw new IllegalArgumentException("ContentArchivingEventAo provided must not be null");
        }
        return new ContentArchivingEvent(ao.getID(), ao.getSpaceKey(), ao.getDate(), ao.getEventType(), ao.getUser(), ModelUtils.deserializeLongSet(ao.getPageIds()), ao.getRemainingPageCount());
    }

    public static List<ContentArchivingEvent> fromAo(ContentArchivingEventAo[] eventAos) {
        if (eventAos == null) {
            return Collections.emptyList();
        }
        ArrayList<ContentArchivingEvent> result = new ArrayList<ContentArchivingEvent>(eventAos.length);
        for (ContentArchivingEventAo event : eventAos) {
            result.add(ContentArchivingEvent.fromAo(event));
        }
        return result;
    }

    public ContentArchivingEvent(String spaceKey, Date date, ArchivingEventType eventType, String user, Set<Long> pageIds, int remainingPageCount) {
        this(0, spaceKey, date, eventType, user, pageIds, remainingPageCount);
    }

    private ContentArchivingEvent(int id, String spaceKey, Date date, ArchivingEventType eventType, String user, Set<Long> pageIds, int remainingPageCount) {
        this.id = id;
        this.spaceKey = spaceKey;
        this.date = date;
        this.eventType = eventType;
        this.user = user;
        this.pageIds = pageIds;
        this.remainingPageCount = remainingPageCount;
    }

    public long getTotalPageCount() {
        return this.getPageIds().size() + this.getRemainingPageCount();
    }

    public String getAction() {
        switch (this.eventType) {
            case ARCHIVED: {
                return CollectionUtils.isNotEmpty(this.pageIds) ? "archived" : "No page needs to be archived";
            }
            case EXPIRED: {
                return CollectionUtils.isNotEmpty(this.pageIds) ? "are expired" : "All pages are up-to-date";
            }
            case SKIPPED: {
                return "skipped";
            }
            case UPDATED: {
                return "updated";
            }
        }
        throw new IllegalStateException("Unknown event type");
    }

    public int getId() {
        return this.id;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public Date getDate() {
        return this.date;
    }

    public ArchivingEventType getType() {
        return this.eventType;
    }

    public String getUser() {
        return this.user;
    }

    public Set<Long> getPageIds() {
        return this.pageIds;
    }

    public int getRemainingPageCount() {
        return this.remainingPageCount;
    }

    public String toString() {
        return "ContentArchivingEvent{id=" + this.id + ", date=" + this.date + ", spaceKey='" + this.spaceKey + '\'' + ", eventType=" + (Object)((Object)this.eventType) + ", user='" + this.user + '\'' + ", pageIds=" + this.pageIds + ", remainingPageCount=" + this.remainingPageCount + '}';
    }
}

