;var ARCHIVING_CONTENT_STATUS_COMMON = (function($) {
	var GENERIC_AJAX_ERROR_MESSAGE = "Failed to get data from the server. Please reload the page.";
	var SEE_BROWSER_CONSOLE = "See the Confluence log and your browser's console for error details.";
	var GENERIC_TECHNICAL_DETAILS = "Technical details:\n\n";

	var buildAndLogErrorMessage = function(jqXHR) {
		var message = GENERIC_AJAX_ERROR_MESSAGE;
		var technicalInfo = $.trim(generateTechnicalInfo(jqXHR));
		if (technicalInfo) {
			message += "<br>" + SEE_BROWSER_CONSOLE;
			console.log(technicalInfo);
		}
		return message;
	};

	var generateTechnicalInfo = function(jqXHR) {
		var stackTrace = "";
		try {
			var responseObject = $.parseJSON(jqXHR.responseText);
			stackTrace = $.map(responseObject["stack-trace"].split('\n').slice(0, 10), $.trim).join("\n"); // get only first lines for brevity
		} catch (e) {
			// ignore
		}
		return stackTrace ? (GENERIC_TECHNICAL_DETAILS + $.trim(stackTrace)) : "";
	};

	return {
		REST_BASE_URL: "/rest/archiving/1.0/content-status/",
		buildAndLogErrorMessage: buildAndLogErrorMessage
	}
})(jQuery);
