/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.web.rest.model;

import com.midori.confluence.plugin.archiving.web.rest.model.ContentStatusType;
import com.midori.confluence.plugin.archiving.web.support.UserFriendlyDateFormatter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;

@XmlRootElement
public class ContentStatusSummary {
    private ContentStatusType type;
    private Long ancestorId;
    private String userName;
    private Date date;
    private long days;
    private long days2;

    public static ContentStatusSummary createWithType(ContentStatusType type) {
        return new ContentStatusSummary(type);
    }

    private ContentStatusSummary(ContentStatusType type) {
        this.type = type;
    }

    public ContentStatusSummary viaAncestor(Long ancestorId) {
        this.ancestorId = ancestorId;
        return this;
    }

    public ContentStatusSummary by(String userName) {
        this.userName = userName;
        return this;
    }

    public ContentStatusSummary at(Date date) {
        this.date = date;
        return this;
    }

    public ContentStatusSummary forDays(long days) {
        this.days = days;
        return this;
    }

    public ContentStatusSummary forDays2(long days2) {
        this.days2 = days2;
        return this;
    }

    public ContentStatusType getType() {
        return this.type;
    }

    @XmlElement
    public String getCode() {
        return this.type.getCode();
    }

    @XmlElement
    public String getSummary() {
        return this.type.getSummary();
    }

    @XmlElement
    public String getDescription() {
        return this.renderText(this.type.getDescription());
    }

    @XmlElement
    public String getSubDescription() {
        return this.renderText(this.type.getSubDescription());
    }

    @XmlElement
    public Long getAncestorId() {
        return this.ancestorId;
    }

    @XmlElement
    public boolean isViaAncestor() {
        return this.ancestorId != null;
    }

    private String renderText(String text) {
        if (text == null) {
            return "";
        }
        LinkedHashMap<String, String> placeholders = new LinkedHashMap<String, String>();
        placeholders.put("%user%", StringUtils.defaultString((String)this.userName, (String)"unknown"));
        placeholders.put("%date%", UserFriendlyDateFormatter.getInstance().formatRelative(this.date));
        placeholders.put("%days%", Long.toString(this.days));
        placeholders.put("%days2%", Long.toString(this.days2));
        placeholders.put("\\?\\(([\\w\\s]+)\\)", this.isViaAncestor() ? "$1" : "");
        for (Map.Entry placeholder : placeholders.entrySet()) {
            text = text.replaceAll((String)placeholder.getKey(), (String)placeholder.getValue());
        }
        return text.trim();
    }
}

