/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.util.limited;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Iterator;

public class LimitedIterable<T>
implements Iterable<T> {
    private Collection<T> collection;
    private int maxSize;
    private int nonLimitedSize;

    public LimitedIterable(Collection<T> collection, int maxSize, int nonLimitedSize) {
        this.collection = collection;
        this.maxSize = maxSize;
        this.nonLimitedSize = nonLimitedSize;
    }

    public void add(T item) {
        this.collection.add(item);
    }

    @Override
    public Iterator<T> iterator() {
        return Iterables.limit(this.collection, (int)this.maxSize).iterator();
    }

    public int getRemainingCount() {
        int limitedSize = Math.min(this.collection.size(), this.maxSize);
        return this.nonLimitedSize <= limitedSize ? 0 : this.nonLimitedSize - limitedSize;
    }

    public boolean hasRemaining() {
        return this.getRemainingCount() > 0;
    }
}

