/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support.reduce;

import com.midori.confluence.plugin.archiving.model.Anonymizable;
import com.midori.confluence.plugin.archiving.model.PageArchiving;
import com.midori.confluence.plugin.archiving.service.support.reduce.LightPage;

public class LightPageArchiving
implements Anonymizable<LightPageArchiving> {
    private LightPage freshPage;
    private String archivingAction;
    private String archiverName;
    private String reason;
    private boolean skipped;

    public static LightPageArchiving fromPageArchiving(PageArchiving pageArchiving) {
        return new LightPageArchiving(pageArchiving);
    }

    @Override
    public LightPageArchiving anonymized() {
        return new LightPageArchiving(this.freshPage, this.archivingAction, "undisclosed user", this.reason, this.skipped);
    }

    private LightPageArchiving(PageArchiving pageArchiving) {
        this(pageArchiving.getFreshPage() != null ? LightPage.fromPage(pageArchiving.getFreshPage()) : null, pageArchiving.getArchivingAction(), pageArchiving.getArchiverName(), pageArchiving.getReason(), pageArchiving.isSkipped());
    }

    private LightPageArchiving(LightPage freshPage, String archivingAction, String archiverName, String reason, boolean skipped) {
        this.freshPage = freshPage;
        this.archivingAction = archivingAction;
        this.archiverName = archiverName;
        this.reason = reason;
        this.skipped = skipped;
    }

    public LightPage getFreshPage() {
        return this.freshPage;
    }

    public String getArchivingAction() {
        return this.archivingAction;
    }

    public String getArchiverName() {
        return this.archiverName;
    }

    public boolean isAutomatic() {
        return this.archiverName == null;
    }

    public String getReason() {
        return this.reason;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public String toString() {
        return String.format("LightPageArchiving \"%s\" %s by %s (skipped: %s)", this.freshPage != null ? this.freshPage.getTitle() : "<no page>", this.archivingAction, this.archiverName, this.skipped);
    }
}

