/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.support;

import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.extras.common.LicenseException;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentLifecycleStatusHelper {
    private static Logger log = LoggerFactory.getLogger(ContentLifecycleStatusHelper.class);
    private PluginLicenseManager licenseManager;

    public ContentLifecycleStatusHelper(PluginLicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public boolean isDisposable() {
        if (ConfluenceSystemProperties.isDevMode()) {
            return true;
        }
        LifecycleStatus lifecycleStatus = this.getLifecycleStatus();
        return lifecycleStatus == LifecycleStatus.LIMITED || lifecycleStatus == LifecycleStatus.COMPLETE;
    }

    public boolean isDraft() {
        if (ConfluenceSystemProperties.isDevMode()) {
            return false;
        }
        LifecycleStatus lifecycleStatus = this.getLifecycleStatus();
        return lifecycleStatus == LifecycleStatus.LIMITED;
    }

    private LifecycleStatus getLifecycleStatus() {
        try {
            if (this.licenseManager.getLicense().isDefined()) {
                PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
                if (pluginLicense.getError().isDefined()) {
                    log.warn(String.format("Error with %s license: %s. %s", ContentLifecycleStatusHelper.getPluginName(), ((LicenseError)pluginLicense.getError().get()).name(), ContentLifecycleStatusHelper.getVisitText()));
                    return LifecycleStatus.ERROR_OR_MISSING;
                }
                if (pluginLicense.isEvaluation()) {
                    return LifecycleStatus.LIMITED;
                }
                return LifecycleStatus.COMPLETE;
            }
            log.warn(String.format("No license is installed for %s. %s", ContentLifecycleStatusHelper.getPluginName(), ContentLifecycleStatusHelper.getVisitText()));
            return LifecycleStatus.ERROR_OR_MISSING;
        }
        catch (LicenseException ex) {
            log.error(String.format("Failed to check license for %s", ContentLifecycleStatusHelper.getPluginName()), (Throwable)ex);
            return LifecycleStatus.ERROR_OR_MISSING;
        }
    }

    private static String getPluginName() {
        return "Better Content Archiving for Confluence";
    }

    private static String getVisitText() {
        return "Purchase a supported license at https://www.atlassian.com/purchase/addon/com.midori.confluence.plugin.archiving or get a free trial license at https://www.midori-global.com/products/better-content-archiving-for-confluence/server/buy#try or contact info@midori-global.com";
    }

    private static enum LifecycleStatus {
        LIMITED,
        COMPLETE,
        ERROR_OR_MISSING;

    }
}

