/*
 * Decompiled with CFR 0.152.
 */
package com.midori.confluence.plugin.archiving.service.strategy.replication;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.DefaultSaveContext;
import com.atlassian.confluence.core.Modification;
import com.atlassian.confluence.core.SaveContext;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.ConfluenceIndexer;
import com.atlassian.confluence.security.ContentPermission;
import com.atlassian.confluence.security.ContentPermissionSet;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.midori.confluence.plugin.archiving.model.util.ModelUtils;
import com.midori.confluence.plugin.archiving.service.strategy.replication.ReplicationUtils;
import com.midori.confluence.plugin.archiving.service.strategy.replication.comparator.AttachmentComparator;
import com.midori.confluence.plugin.archiving.service.strategy.replication.comparator.CommentComparator;
import com.midori.confluence.plugin.archiving.service.strategy.replication.comparator.LabellingComparator;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageReplicator {
    private static Logger log = LoggerFactory.getLogger(PageReplicator.class);
    private static final SaveContext SILENT_SAVE_CONTEXT = new DefaultSaveContext(true, true, true);
    public static final int RENAMED_PAGE_TITLE_PREFIX_MAX_LEN = 200;
    private static final Set<String> NON_GLOBAL_NON_REPLICABLE_LABELS = new HashSet<String>(Arrays.asList("favourite", "favorite"));
    private static final Set<String> GLOBAL_NON_REPLICABLE_LABELS = new HashSet<String>(Arrays.asList("noarchive", "noarchive-single", "expire-\\d{2}\\/\\d{1,2}\\/\\d{1,2}", "expire-single-\\d{2}\\/\\d{1,2}\\/\\d{1,2}", "archive", "archive-single", "archive-\\d{2}\\/\\d{1,2}\\/\\d{1,2}", "archive-single-\\d{2}\\/\\d{1,2}\\/\\d{1,2}", "archive-review", "archive-update"));
    private static final Predicate<Label> replicableLabelsPredicate = new Predicate<Label>(){

        public boolean apply(Label label) {
            String labelName = label.getName();
            if (Namespace.isGlobal((Label)label)) {
                for (String globalNonReplicableLabel : GLOBAL_NON_REPLICABLE_LABELS) {
                    if (!labelName.matches(globalNonReplicableLabel)) continue;
                    return false;
                }
            } else {
                for (String nonGlobalNonReplicableLabel : NON_GLOBAL_NON_REPLICABLE_LABELS) {
                    if (!labelName.equals(nonGlobalNonReplicableLabel)) continue;
                    return false;
                }
            }
            return true;
        }
    };
    private static final Predicate<Label> nonReplicableLabelsPredicate = Predicates.not(replicableLabelsPredicate);
    private static final Predicate<Labelling> replicableLabellingsPredicate = new Predicate<Labelling>(){

        public boolean apply(Labelling labelling) {
            return replicableLabelsPredicate.apply((Object)labelling.getLabel());
        }
    };
    private AttachmentManager attachmentManager;
    private CommentManager commentManager;
    private ConfluenceIndexer confluenceIndexer;
    private ContentPermissionManager contentPermissionManager;
    private LabelManager labelManager;
    private PageManager pageManager;
    private SpaceManager spaceManager;
    private UserAccessor userAccessor;

    public PageReplicator(AttachmentManager attachmentManager, CommentManager commentManager, ConfluenceIndexer confluenceIndexer, ContentPermissionManager contentPermissionManager, LabelManager labelManager, PageManager pageManager, SpaceManager spaceManager, UserAccessor userAccessor) {
        this.attachmentManager = attachmentManager;
        this.commentManager = commentManager;
        this.confluenceIndexer = confluenceIndexer;
        this.contentPermissionManager = contentPermissionManager;
        this.labelManager = labelManager;
        this.pageManager = pageManager;
        this.spaceManager = spaceManager;
        this.userAccessor = userAccessor;
    }

    public Page replicate(long pageId, String targetSpaceKey, long targetParentPageId) {
        Page page = this.pageManager.getPage(pageId);
        Page newPage = this.copyPage(page, targetSpaceKey, targetParentPageId, null);
        this.copyContentPermissionSets(page, newPage);
        this.copyPageComments(page, newPage);
        this.copyPageAttachments(page, newPage);
        this.copyPageLabels(page, newPage);
        return newPage;
    }

    public Page replicate(long pageId, long targetPageId) {
        final Page page = this.pageManager.getPage(pageId);
        Page targetPage = this.pageManager.getPage(targetPageId);
        if (!targetPage.getBodyAsString().equals(page.getBodyAsString())) {
            log.trace(String.format("Synchronizing content of <%s>", page.getTitle()));
            this.pageManager.saveNewVersion((ContentEntityObject)targetPage, (Modification)new Modification<Page>(){

                public void modify(Page pageToModify) {
                    pageToModify.setBodyAsString(page.getBodyAsString());
                    pageToModify.setLastModificationDate(page.getLastModificationDate());
                    pageToModify.setLastModifier(page.getLastModifier());
                }
            }, SILENT_SAVE_CONTEXT);
        }
        if (this.arePageCommentsDifferent(page, targetPage)) {
            log.trace(String.format("Synchronizing comments of <%s>", page.getTitle()));
            this.removeAllPageComments(targetPage);
            this.copyPageComments(page, targetPage);
        }
        if (this.arePageAttachmentsDifferent(page, targetPage)) {
            log.trace(String.format("Synchronizing attachments of <%s>", page.getTitle()));
            this.removeAllPageAttachments(targetPage);
            this.copyPageAttachments(page, targetPage);
        }
        if (this.arePageLabelsDifferent(page, targetPage)) {
            log.trace(String.format("Synchronizing labels of <%s>", page.getTitle()));
            this.removeAllPageLabels(targetPage);
            this.copyPageLabels(page, targetPage);
        }
        return targetPage;
    }

    public Page createProxy(long pageId, String targetSpaceKey, long targetParentPageId, String content) {
        Page page = this.pageManager.getPage(pageId);
        Page newPage = this.copyPage(page, targetSpaceKey, targetParentPageId, content);
        return newPage;
    }

    private Page copyPage(Page page, String targetSpaceKey, long targetParentPageId, String content) {
        Space targetSpace = this.spaceManager.getSpace(targetSpaceKey);
        Page targetParentPage = targetParentPageId != 0L ? this.pageManager.getPage(targetParentPageId) : null;
        Page newPage = new Page();
        newPage.setSpace(targetSpace);
        newPage.setParentPage(targetParentPage);
        newPage.setTitle(page.getTitle());
        newPage.setBodyAsString(StringUtils.isBlank((String)content) ? page.getBodyAsString() : content);
        ReplicationUtils.copyConfluenceEntityObjectProperties((ConfluenceEntityObject)page, (ConfluenceEntityObject)newPage);
        if (newPage.getParent() != null) {
            newPage.getParent().addChild(newPage);
        }
        this.pageManager.saveContentEntity((ContentEntityObject)newPage, SILENT_SAVE_CONTEXT);
        if (page.isHomePage()) {
            targetSpace.setHomePage(newPage);
            this.spaceManager.saveSpace(targetSpace);
        }
        return newPage;
    }

    public void addNewPageVersion(long pageId, final String versionComment, boolean recursively) {
        log.debug(String.format("Adding new version to page #%d", pageId));
        Page page = this.pageManager.getPage(pageId);
        if (page == null) {
            throw new IllegalStateException(String.format("Failed to find page #%d", pageId));
        }
        this.pageManager.saveNewVersion((ContentEntityObject)page, (Modification)new Modification<Page>(){

            public void modify(Page pageToModify) {
                pageToModify.setVersionComment(versionComment);
            }
        }, DefaultSaveContext.SUPPRESS_NOTIFICATIONS);
        if (recursively) {
            for (Page childPage : page.getChildren()) {
                this.addNewPageVersion(childPage.getId(), versionComment, recursively);
            }
        }
    }

    public void move(Page page, Page targetParent) {
        assert (targetParent == null || targetParent.getSpace().equals((Object)page.getSpace())) : "This method moves a page within its space, use moveToSpace() to move the page to another space";
        if (targetParent != null) {
            this.pageManager.movePageAsChild(page, targetParent);
        } else {
            this.pageManager.movePageToTopLevel(page, page.getSpace());
        }
    }

    public boolean moveToSpace(Page page, Space targetSpace, Page targetParent) {
        assert (targetParent != null && targetSpace.equals((Object)targetParent.getSpace()) && !page.getSpace().equals((Object)targetParent.getSpace()) || targetParent == null && targetSpace != null && !page.getSpace().equals((Object)targetSpace)) : "This method moves a page to a another space, use move() within a space";
        Page conflictingPage = this.pageManager.getPage(targetSpace.getKey(), page.getTitle());
        if (conflictingPage != null) {
            String uniqueTitle = PageReplicator.createUniqueTitle(conflictingPage.getTitle());
            this.pageManager.renamePage((AbstractPage)conflictingPage, uniqueTitle);
        }
        if (targetParent != null) {
            this.pageManager.movePageAsChild(page, targetParent);
        } else {
            boolean isHomePage = page.isHomePage();
            this.pageManager.movePageToTopLevel(page, targetSpace);
            if (isHomePage) {
                targetSpace.setHomePage(page);
                this.spaceManager.saveSpace(targetSpace);
            }
        }
        this.removeNonReplicableLabels(page);
        if (conflictingPage != null) {
            this.pageManager.moveChildrenToNewParent(conflictingPage, page);
            this.silentlyRemove(conflictingPage);
        }
        return conflictingPage != null;
    }

    public void moveChildrenUp(Page page) {
        if (CollectionUtils.isNotEmpty((Collection)page.getChildren())) {
            boolean hadParent;
            Page parent = page.getParent();
            boolean bl = hadParent = parent != null;
            while (page.hasChildren()) {
                if (hadParent) {
                    this.pageManager.movePageAsChild((Page)page.getChildren().get(0), parent);
                    continue;
                }
                this.pageManager.movePageToTopLevel((Page)page.getChildren().get(0), page.getSpace());
            }
        }
    }

    public void silentlyRemove(Page page) {
        this.moveChildrenUp(page);
        page.trash();
        Space space = page.getSpace();
        if (page.equals((Object)space.getHomePage())) {
            space.setHomePage(null);
        }
        this.confluenceIndexer.unIndexIncludingDependents((Searchable)page);
    }

    private void copyContentPermissionSets(Page fromPage, Page toPage) {
        ContentPermissionSet permissionSet = fromPage.getContentPermissionSet("View");
        if (permissionSet != null) {
            this.addContentPermissionSet(toPage, permissionSet);
        }
        if ((permissionSet = fromPage.getContentPermissionSet("Edit")) != null) {
            this.addContentPermissionSet(toPage, permissionSet);
        }
    }

    private void addContentPermissionSet(Page page, ContentPermissionSet permissionSet) {
        for (ContentPermission contentPermission : permissionSet) {
            ContentPermission newContentPermission = contentPermission.isUserPermission() ? ContentPermission.createUserPermission((String)contentPermission.getType(), (ConfluenceUser)contentPermission.getUserSubject()) : ContentPermission.createGroupPermission((String)contentPermission.getType(), (String)contentPermission.getGroupName());
            this.contentPermissionManager.addContentPermission(newContentPermission, (ContentEntityObject)page);
        }
    }

    private boolean arePageCommentsDifferent(Page page1, Page page2) {
        return !ModelUtils.equalCollections(page1.getComments(), page2.getComments(), CommentComparator.INSTANCE);
    }

    private void removeAllPageComments(Page page) {
        ArrayList<Long> commentIds = new ArrayList<Long>(page.getComments().size());
        for (Comment comment : page.getComments()) {
            commentIds.add(comment.getId());
        }
        for (Long commentId : commentIds) {
            this.commentManager.removeCommentFromObject(commentId.longValue());
        }
    }

    private void copyPageComments(Page fromPage, Page toPage) {
        List comments = fromPage.getComments();
        HashMap<Long, Comment> idToNewComment = new HashMap<Long, Comment>();
        for (Comment comment : comments) {
            Comment newParent = null;
            if (comment.getParent() != null) {
                Long parentId = new Long(comment.getParent().getId());
                newParent = (Comment)idToNewComment.get(parentId);
            }
            String originalComment = comment.getBodyAsString();
            String rewrittenComment = this.rewriteTextByRemovingMentions(originalComment);
            Comment newComment = this.commentManager.addCommentToObject((ContentEntityObject)toPage, newParent, rewrittenComment);
            ReplicationUtils.copyConfluenceEntityObjectProperties((ConfluenceEntityObject)comment, (ConfluenceEntityObject)newComment);
            idToNewComment.put(comment.getId(), newComment);
        }
    }

    private boolean arePageAttachmentsDifferent(Page page1, Page page2) {
        return !ModelUtils.equalCollections(page1.getAttachments(), page2.getAttachments(), AttachmentComparator.INSTANCE);
    }

    private void removeAllPageAttachments(Page page) {
        List attachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)page);
        this.attachmentManager.removeAttachments(attachments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyPageAttachments(Page fromPage, Page toPage) {
        List attachments = this.attachmentManager.getLatestVersionsOfAttachments((ContentEntityObject)fromPage);
        for (Attachment attachment : attachments) {
            InputStream data = this.attachmentManager.getAttachmentData(attachment);
            if (data != null) {
                long bytesAvailable = ReplicationUtils.countInputStreamBytes(data);
                if (bytesAvailable != attachment.getFileSize()) {
                    log.warn(String.format("Attachment <%s> has filesize %d but its stream has %d bytes available", attachment, attachment.getFileSize(), bytesAvailable));
                }
                Attachment newAttachment = new Attachment();
                newAttachment.setFileName(attachment.getFileName());
                newAttachment.setFileSize(bytesAvailable != -1L ? bytesAvailable : attachment.getFileSize());
                newAttachment.setMediaType(attachment.getMediaType());
                newAttachment.setVersionComment(attachment.getVersionComment());
                newAttachment.setVersion(1);
                newAttachment.setContainer((ContentEntityObject)toPage);
                InputStream data2 = this.attachmentManager.getAttachmentData(attachment);
                try {
                    ReplicationUtils.copyConfluenceEntityObjectProperties((ConfluenceEntityObject)attachment, (ConfluenceEntityObject)newAttachment);
                    this.attachmentManager.saveAttachment(newAttachment, null, data2);
                    continue;
                }
                catch (Exception ex) {
                    log.error("Failed to copy attachment <" + attachment + "> from <" + fromPage + "> to <" + toPage + ">", (Throwable)ex);
                    continue;
                }
                finally {
                    IOUtils.closeQuietly(data);
                    IOUtils.closeQuietly(data2);
                    continue;
                }
            }
            log.warn("Attachment <" + attachment + "> has null data");
        }
    }

    private boolean arePageLabelsDifferent(Page page1, Page page2) {
        return !ModelUtils.equalCollections(PageReplicator.filterReplicableLabellings(page1.getLabellings()), PageReplicator.filterReplicableLabellings(page2.getLabellings()), LabellingComparator.INSTANCE);
    }

    private void removeAllPageLabels(Page page) {
        this.labelManager.removeAllLabels((Labelable)page);
    }

    private void removeNonReplicableLabels(Page page) {
        List<Label> nonReplicableLabels = PageReplicator.filterNonReplicableLabels(page.getLabels());
        if (!nonReplicableLabels.isEmpty()) {
            this.labelManager.removeLabels((Labelable)page, nonReplicableLabels);
        }
    }

    private void copyPageLabels(Page fromPage, Page toPage) {
        List<Label> replicableLabels = PageReplicator.filterReplicableLabels(fromPage.getLabels());
        for (Label label : replicableLabels) {
            if (this.labelManager.addLabel((Labelable)toPage, label) == 1) continue;
            log.warn(String.format("Adding label <%s> to page <%s> failed", label.getName(), toPage.getTitle()));
        }
    }

    private static String createUniqueTitle(String title) {
        if (title.length() > 200) {
            title = title.substring(0, 200);
        }
        return title + " toBeDeleted_" + System.currentTimeMillis();
    }

    static List<Label> filterReplicableLabels(List<Label> labels) {
        return new ArrayList<Label>(Collections2.filter(labels, replicableLabelsPredicate));
    }

    static List<Label> filterNonReplicableLabels(List<Label> labels) {
        return new ArrayList<Label>(Collections2.filter(labels, nonReplicableLabelsPredicate));
    }

    static List<Labelling> filterReplicableLabellings(List<Labelling> labellings) {
        return new ArrayList<Labelling>(Collections2.filter(labellings, replicableLabellingsPredicate));
    }

    private String rewriteTextByRemovingMentions(String text) {
        int start;
        String rewrittenText = text;
        int startFrom = 0;
        while ((start = StringUtils.indexOf((String)rewrittenText, (String)"<ac:link><ri:user", (int)startFrom)) != -1) {
            int end = StringUtils.indexOf((String)rewrittenText, (String)"</ac:link>", (int)start);
            if (end != -1) {
                String mentionLink = rewrittenText.substring(start, end + "</ac:link>".length());
                String replaceWith = null;
                String userKey = StringUtils.substringBetween((String)mentionLink, (String)"ri:userkey=\"", (String)"\"");
                if (StringUtils.isNotBlank((String)userKey)) {
                    ConfluenceUser user = this.userAccessor.getUserByKey(new UserKey(userKey));
                    replaceWith = user != null ? user.getName() : userKey;
                } else {
                    String userName = StringUtils.substringBetween((String)mentionLink, (String)"ri:username=\"", (String)"\"");
                    if (StringUtils.isNotBlank((String)userName)) {
                        replaceWith = userName;
                    }
                }
                if (replaceWith != null) {
                    rewrittenText = StringUtils.replace((String)rewrittenText, (String)mentionLink, (String)replaceWith);
                }
            }
            ++startFrom;
        }
        return rewrittenText;
    }
}

