;(function($) {
	var DELAY = 300;
	var triggerSelector = "#status #taskProgressBar";
	var percentageSelector = "#percentComplete";
	$(triggerSelector).livequery(function() {
		var baseUrl = AJS.Meta.get("base-url");
		var spaceKey = AJS.Meta.get("space-key");
		var taskId = AJS.Meta.get("taskId");
		var percentageElem = $(percentageSelector);

		var onCompleted = function() {
			if (percentageElem.text().indexOf("100") >= 0) {
				var url = baseUrl + (spaceKey ? "" : "/admin/plugins") +
					"/archiving/long-running-task-completed.action?taskId=" + taskId + (spaceKey ? ("&key=" + spaceKey) : "");
				var resultsButton = $("<a>", {
					"class": "aui-button aui-button-primary hidden",
					"href": url
				}).text("Go to results");
				resultsButton.insertAfter($("#status")).fadeIn(function() {
					// since Confluence 7, fadeIn() does not work on an element with "hidden" class so we remove it manually
					$(this).removeClass("hidden");
				});
				$("#taskGreenBar").css("background", "#14892c"); // "AUI green"
			} else {
				setTimeout(onCompleted, DELAY);
			}
		};
		setTimeout(onCompleted, DELAY);

		$(triggerSelector).livequeryExpire();
	});
})(jQuery);